% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ifit-methods}
\alias{ifit-methods}
\alias{coef.ifit}
\alias{vcov.ifit}
\alias{confint.ifit}
\alias{controlIFIT}
\alias{globalIFIT}
\alias{jacobianIFIT}
\alias{numsimIFIT}
\alias{diagIFIT}
\alias{estfunIFIT}
\title{Methods for \code{ifit} objects}
\usage{
\method{coef}{ifit}(object, ...)

\method{vcov}{ifit}(object, type = c("parameters", "statistics"), ...)

\method{confint}{ifit}(object, parm, level = 0.95, ...)

controlIFIT(object)

globalIFIT(object)

jacobianIFIT(object)

numsimIFIT(object)

diagIFIT(object, plot = TRUE)

estfunIFIT(object)
}
\arguments{
\item{object}{an object returned by \code{ifit}}

\item{...}{additional arguments, currently not used}

\item{type}{should the (estimated) covariance matrix of the
parameters or of summary statistics returned?}

\item{parm}{a specification of which parameters are to be given
confidence intervals.}

\item{level}{the confidence level required.}

\item{plot}{if TRUE the summary statistics are plotted and the object
is returned as invisible; otherwise, the statistics are not plotted
and the object is returned as visible.}
}
\value{
\code{coef} returns a numeric vector with the estimated parameters

\code{vcov} returns a numeric matrix containing either the
estimates or summary statistics variance-covariance matrix.

\code{confint} returns a matrix (or vector) with columns giving lower and upper
confidence limits for each parameter. The intervals assume the
asymptotic normality of the summary statistics.

\code{controlIFIT} return a list containing the values of the constants
\code{Ninit}, \code{NFitlocal},... used to estimate the model.

\code{globalIFIT} return the vector of the estimated parameters after
the global search

\code{jacobianIFIT} returns a numeric matrix containing the estimated
jacobian of the summary statistcs mean.

\code{numsimIFIT} returns an integer vector of length 2 containing the
number of simulations used during the global and local search
phases.

\code{diagIFIT} returns, and optionally plot,  a numeric vector containing
the observed summary statistics standardized with their means and
standard deviances estimated at the final parameters; and, as attributes,
the Sargan-Hansen test statistic, its degrees of freedom and
the corresponding p-value. The
class of the returned object is \code{ifit.diag} for which suitable
print and plot methods are available.

\code{estfunIFIT} returns a numeric vector containing the estimating function evaluated
at the final parameters; as attributes, the function also returns
the estimated standard errors of the estimating function, its Mahalanobis norm
and the number of degree of freedom. The
class of the returned object is \code{ifit.estfun} for which a suitable
print method is available.
}
\description{
Methods and functions usable fo extracting information from an object
of class \code{ifit}
}
\keyword{methods}
