% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_statistics.R
\name{dim.hstats_matrix}
\alias{dim.hstats_matrix}
\title{Dimensions of "hstats_matrix" Object}
\usage{
\method{dim}{hstats_matrix}(x)
}
\arguments{
\item{x}{An object of class "hstats_matrix".}
}
\value{
A numeric vector of length two providing the number of rows and columns
of "M" object stored in \code{x}.
}
\description{
Implies \code{nrow()} and \code{ncol()}.
}
\examples{
fit <- lm(Sepal.Length ~ . + Petal.Width:Species, data = iris)
s <- hstats(fit, X = iris[-1])
x <- h2_pairwise(s)
dim(x)
nrow(x)
ncol(x)
}
