% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{admiral_vs_tbl_df}
\alias{admiral_vs_tbl_df}
\title{Vital Signs Dataset}
\format{
A data frame with 29,643 observations and 24 variables:
\describe{
  \item{STUDYID}{Character string indicating the study identifier}
  \item{DOMAIN}{Character string indicating the domain abbreviation}
  \item{USUBJID}{Character string indicating the unique subject identifier}
  \item{VSSEQ}{Numeric value indicating the sequence number}
  \item{VSTESTCD}{Character string indicating the vital signs test short name}
  \item{VSTEST}{Character string indicating the vital signs test name}
  \item{VSPOS}{Character string indicating the subject’s position during measurement}
  \item{VSORRES}{Character string indicating the result or finding in original units}
  \item{VSORRESU}{Character string indicating the original measurement units}
  \item{VSSTRESC}{Character string indicating the character result/finding in standard format}
  \item{VSSTRESN}{Numeric value indicating the result/finding in standard units}
  \item{VSSTRESU}{Character string indicating the standard units}
  \item{VSSTAT}{Character string indicating the completion status}
  \item{VSLOC}{Character string indicating the location of the measurement}
  \item{VSBLFL}{Character string indicating whether the value is a baseline flag}
  \item{VISITNUM}{Numeric value indicating the visit number}
  \item{VISIT}{Character string indicating the visit name}
  \item{VISITDY}{Numeric value indicating the planned study day of the visit}
  \item{VSDTC}{Character string indicating the date/time of measurements}
  \item{VSDY}{Numeric value indicating the study day of vital signs}
  \item{VSTPT}{Character string indicating the planned time point name}
  \item{VSTPTNUM}{Numeric value indicating the planned time point number}
  \item{VSELTM}{Character string indicating the planned elapsed time from the time point reference}
  \item{VSTPTREF}{Character string indicating the time point reference}
}
}
\source{
Data taken from the admiral.test package version 0.7.0.
}
\usage{
data(admiral_vs_tbl_df)
}
\description{
This dataset, admiral_vs_tbl_df, is a tibble data frame containing a CDISC SDTM VS dataset
from the CDISC pilot project. It includes study identifiers, subject identifiers,
vital signs test codes, test names, measurement results, visit information, and
related metadata. The dataset follows the structure of clinical trial data and
provides standardized vital signs information.
}
\details{
The dataset name has been kept as 'admiral_vs_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been
modified in any way.
}
