% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.nc.hdsvm-methods.R
\name{predict.cv.nc.hdsvm}
\alias{predict.cv.nc.hdsvm}
\title{Make Predictions from a `cv.nc.hdsvm` Object}
\usage{
\method{predict}{cv.nc.hdsvm}(
  object,
  newx,
  s = c("lambda.1se", "lambda.min"),
  type = c("class", "loss"),
  ...
)
}
\arguments{
\item{object}{A fitted `cv.nc.hdsvm()` object from which predictions are to be made.}

\item{newx}{Matrix of new predictor values for which predictions are desired.
This must be a matrix and is a required argument.}

\item{s}{Specifies the value(s) of the penalty parameter `lambda` at which predictions
are desired. The default is `s = "lambda.1se"`, representing the largest value of `lambda`
such that the cross-validation error estimate is within one standard error of the minimum.
Alternatively, `s = "lambda.min"` can be used, corresponding to the minimum of the
cross-validation error estimate. If `s` is numeric, these are taken as the actual values
of `lambda` to use for predictions.}

\item{type}{Type of prediction required. Type `"class"` produces the predicted binary class labels and
type `"loss"` returns the fitted values. Default is \code{"class"}.}

\item{...}{Not used.}
}
\value{
Returns a matrix or vector of predicted values corresponding to the specified
  `lambda` values.
}
\description{
Generates predictions using a fitted `cv.nc.hdsvm()` object. This function utilizes the
stored `nchdsvm.fit` object and an optimal value of `lambda` determined during the
cross-validation process.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x1 <- matrix(rnorm(n / 2 * p, -0.25, 0.1), n / 2)
x2 <- matrix(rnorm(n / 2 * p, 0.25, 0.1), n / 2)
x <- rbind(x1, x2)
beta <- 0.1 * rnorm(p)
prob <- plogis(c(x \%*\% beta))
y <- 2 * rbinom(n, 1, prob) - 1
lam2 <- 0.01
lambda <- 10^(seq(1,-4, length.out = 30))
\donttest{cv.nc.fit <- cv.nc.hdsvm(x = x, y = y, lambda = lambda, lam2 = lam2, pen = "scad")}
\donttest{predict(cv.nc.fit, newx = x[50:60, ], s = "lambda.min")}
}
\seealso{
\code{\link{cv.nc.hdsvm}}, \code{\link{predict.cv.nc.hdsvm}}
}
