/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5overflow_H
#define H5overflow_H

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_INT8_T
    #define ASSIGN_unsigned_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_INT8_T
    #define ASSIGN_unsigned_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_INT
    #define ASSIGN_unsigned_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_INT
    #define ASSIGN_unsigned_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_LONG
    #define ASSIGN_unsigned_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_LONG
    #define ASSIGN_unsigned_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_INT64_T
    #define ASSIGN_unsigned_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_INT64_T
    #define ASSIGN_unsigned_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_UINT8_T
    #define ASSIGN_unsigned_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_UINT8_T
    #define ASSIGN_unsigned_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_UINT16_T
    #define ASSIGN_unsigned_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_UINT16_T
    #define ASSIGN_unsigned_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_UINT32_T
    #define ASSIGN_unsigned_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_UINT32_T
    #define ASSIGN_unsigned_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_UINT64_T
    #define ASSIGN_unsigned_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_UINT64_T
    #define ASSIGN_unsigned_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_unsigned_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_unsigned_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_SIZE_T
    #define ASSIGN_unsigned_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_SIZE_T
    #define ASSIGN_unsigned_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_SSIZE_T
    #define ASSIGN_unsigned_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_SSIZE_T
    #define ASSIGN_unsigned_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_HADDR_T
    #define ASSIGN_unsigned_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_HADDR_T
    #define ASSIGN_unsigned_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_HSIZE_T
    #define ASSIGN_unsigned_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_HSIZE_T
    #define ASSIGN_unsigned_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_unsigned_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_unsigned_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UNSIGNED < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_unsigned_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UNSIGNED > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_unsigned_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_unsigned_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_int8_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_int8_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_INT
    #define ASSIGN_int8_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_INT
    #define ASSIGN_int8_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_LONG
    #define ASSIGN_int8_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_LONG
    #define ASSIGN_int8_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_INT64_T
    #define ASSIGN_int8_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_INT64_T
    #define ASSIGN_int8_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_int8_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_int8_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_int8_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_int8_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_int8_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_int8_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_int8_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_int8_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_int8_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_int8_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_int8_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_int8_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_int8_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_int8_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_int8_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_int8_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_int8_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_int8_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_int8_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_int8_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT8_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_int8_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT8_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_int8_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int8_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_UNSIGNED
    #define ASSIGN_int_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_UNSIGNED
    #define ASSIGN_int_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_INT8_T
    #define ASSIGN_int_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_INT8_T
    #define ASSIGN_int_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_LONG
    #define ASSIGN_int_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_LONG
    #define ASSIGN_int_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_INT64_T
    #define ASSIGN_int_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_INT64_T
    #define ASSIGN_int_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_UINT8_T
    #define ASSIGN_int_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_UINT8_T
    #define ASSIGN_int_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_UINT16_T
    #define ASSIGN_int_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_UINT16_T
    #define ASSIGN_int_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_UINT32_T
    #define ASSIGN_int_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_UINT32_T
    #define ASSIGN_int_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_UINT64_T
    #define ASSIGN_int_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_UINT64_T
    #define ASSIGN_int_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_int_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_int_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_SIZE_T
    #define ASSIGN_int_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_SIZE_T
    #define ASSIGN_int_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_SSIZE_T
    #define ASSIGN_int_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_SSIZE_T
    #define ASSIGN_int_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_HADDR_T
    #define ASSIGN_int_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_HADDR_T
    #define ASSIGN_int_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_HSIZE_T
    #define ASSIGN_int_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_HSIZE_T
    #define ASSIGN_int_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_int_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_int_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_int_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_int_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_UNSIGNED
    #define ASSIGN_long_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_UNSIGNED
    #define ASSIGN_long_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_INT8_T
    #define ASSIGN_long_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_INT8_T
    #define ASSIGN_long_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_INT
    #define ASSIGN_long_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_INT
    #define ASSIGN_long_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_INT64_T
    #define ASSIGN_long_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_INT64_T
    #define ASSIGN_long_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_UINT8_T
    #define ASSIGN_long_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_UINT8_T
    #define ASSIGN_long_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_UINT16_T
    #define ASSIGN_long_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_UINT16_T
    #define ASSIGN_long_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_UINT32_T
    #define ASSIGN_long_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_UINT32_T
    #define ASSIGN_long_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_UINT64_T
    #define ASSIGN_long_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_UINT64_T
    #define ASSIGN_long_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_long_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_long_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_SIZE_T
    #define ASSIGN_long_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_SIZE_T
    #define ASSIGN_long_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_SSIZE_T
    #define ASSIGN_long_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_SSIZE_T
    #define ASSIGN_long_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_HADDR_T
    #define ASSIGN_long_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_HADDR_T
    #define ASSIGN_long_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_HSIZE_T
    #define ASSIGN_long_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_HSIZE_T
    #define ASSIGN_long_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_long_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_long_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_LONG < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_long_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_LONG > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_long_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_long_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_int64_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_int64_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_INT8_T
    #define ASSIGN_int64_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_INT8_T
    #define ASSIGN_int64_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_INT
    #define ASSIGN_int64_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_INT
    #define ASSIGN_int64_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_LONG
    #define ASSIGN_int64_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_LONG
    #define ASSIGN_int64_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_int64_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_int64_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_int64_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_int64_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_int64_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_int64_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_int64_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_int64_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_int64_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_int64_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_int64_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_int64_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_int64_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_int64_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_int64_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_int64_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_int64_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_int64_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_int64_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_int64_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_INT64_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_int64_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_INT64_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_int64_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_int64_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint8_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint8_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_INT8_T
    #define ASSIGN_uint8_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_INT8_T
    #define ASSIGN_uint8_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_INT
    #define ASSIGN_uint8_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_INT
    #define ASSIGN_uint8_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_LONG
    #define ASSIGN_uint8_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_LONG
    #define ASSIGN_uint8_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_INT64_T
    #define ASSIGN_uint8_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_INT64_T
    #define ASSIGN_uint8_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_uint8_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_uint8_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_uint8_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_uint8_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_uint8_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_uint8_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint8_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint8_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_uint8_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_uint8_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint8_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint8_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_uint8_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_uint8_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint8_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint8_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint8_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint8_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT8_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint8_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT8_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint8_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint8_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint16_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint16_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_INT8_T
    #define ASSIGN_uint16_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_INT8_T
    #define ASSIGN_uint16_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_INT
    #define ASSIGN_uint16_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_INT
    #define ASSIGN_uint16_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_LONG
    #define ASSIGN_uint16_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_LONG
    #define ASSIGN_uint16_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_INT64_T
    #define ASSIGN_uint16_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_INT64_T
    #define ASSIGN_uint16_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_uint16_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_uint16_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_uint16_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_uint16_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_uint16_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_uint16_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint16_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint16_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_uint16_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_uint16_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint16_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint16_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_uint16_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_uint16_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint16_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint16_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint16_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint16_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT16_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint16_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT16_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint16_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint16_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint32_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint32_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_INT8_T
    #define ASSIGN_uint32_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_INT8_T
    #define ASSIGN_uint32_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_INT
    #define ASSIGN_uint32_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_INT
    #define ASSIGN_uint32_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_LONG
    #define ASSIGN_uint32_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_LONG
    #define ASSIGN_uint32_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_INT64_T
    #define ASSIGN_uint32_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_INT64_T
    #define ASSIGN_uint32_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_uint32_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_uint32_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_uint32_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_uint32_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_uint32_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_uint32_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint32_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint32_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_uint32_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_uint32_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint32_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint32_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_uint32_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_uint32_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint32_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint32_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint32_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint32_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT32_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint32_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT32_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint32_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint32_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint64_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_uint64_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_INT8_T
    #define ASSIGN_uint64_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_INT8_T
    #define ASSIGN_uint64_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_INT
    #define ASSIGN_uint64_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_INT
    #define ASSIGN_uint64_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_LONG
    #define ASSIGN_uint64_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_LONG
    #define ASSIGN_uint64_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_INT64_T
    #define ASSIGN_uint64_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_INT64_T
    #define ASSIGN_uint64_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_uint64_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_uint64_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_uint64_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_uint64_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_uint64_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_uint64_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint64_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_uint64_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_uint64_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_uint64_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint64_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_uint64_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_uint64_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_uint64_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint64_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_uint64_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint64_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_uint64_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_UINT64_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint64_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_UINT64_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_uint64_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_uint64_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_ptrdiff_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_ptrdiff_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_INT8_T
    #define ASSIGN_ptrdiff_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_INT8_T
    #define ASSIGN_ptrdiff_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_INT
    #define ASSIGN_ptrdiff_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_INT
    #define ASSIGN_ptrdiff_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_LONG
    #define ASSIGN_ptrdiff_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_LONG
    #define ASSIGN_ptrdiff_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_INT64_T
    #define ASSIGN_ptrdiff_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_INT64_T
    #define ASSIGN_ptrdiff_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_ptrdiff_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_ptrdiff_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_ptrdiff_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_ptrdiff_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_ptrdiff_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_ptrdiff_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_ptrdiff_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_ptrdiff_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_ptrdiff_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_ptrdiff_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_ptrdiff_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_ptrdiff_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_ptrdiff_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_ptrdiff_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_ptrdiff_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_ptrdiff_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_ptrdiff_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_ptrdiff_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_PTRDIFF_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_ptrdiff_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_PTRDIFF_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_ptrdiff_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ptrdiff_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_size_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_size_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_INT8_T
    #define ASSIGN_size_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_INT8_T
    #define ASSIGN_size_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_INT
    #define ASSIGN_size_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_INT
    #define ASSIGN_size_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_LONG
    #define ASSIGN_size_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_LONG
    #define ASSIGN_size_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_INT64_T
    #define ASSIGN_size_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_INT64_T
    #define ASSIGN_size_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_size_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_size_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_size_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_size_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_size_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_size_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_size_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_size_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_size_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_size_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_size_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_size_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_size_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_size_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_size_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_size_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_size_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_size_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SIZE_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_size_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SIZE_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_size_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_size_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_ssize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_ssize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_INT8_T
    #define ASSIGN_ssize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_INT8_T
    #define ASSIGN_ssize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_INT
    #define ASSIGN_ssize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_INT
    #define ASSIGN_ssize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_LONG
    #define ASSIGN_ssize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_LONG
    #define ASSIGN_ssize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_INT64_T
    #define ASSIGN_ssize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_INT64_T
    #define ASSIGN_ssize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_ssize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_ssize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_ssize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_ssize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_ssize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_ssize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_ssize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_ssize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_ssize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_ssize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_ssize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_ssize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_ssize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_ssize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_ssize_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_ssize_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_ssize_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_ssize_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_SSIZE_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_ssize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_SSIZE_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_ssize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_ssize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_haddr_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_haddr_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_INT8_T
    #define ASSIGN_haddr_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_INT8_T
    #define ASSIGN_haddr_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_INT
    #define ASSIGN_haddr_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_INT
    #define ASSIGN_haddr_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_LONG
    #define ASSIGN_haddr_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_LONG
    #define ASSIGN_haddr_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_INT64_T
    #define ASSIGN_haddr_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_INT64_T
    #define ASSIGN_haddr_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_haddr_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_haddr_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_haddr_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_haddr_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_haddr_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_haddr_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_haddr_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_haddr_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_haddr_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_haddr_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_haddr_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_haddr_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_haddr_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_haddr_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_haddr_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_haddr_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_haddr_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_haddr_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HADDR_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_haddr_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HADDR_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_haddr_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_haddr_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_hsize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_hsize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_INT8_T
    #define ASSIGN_hsize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_INT8_T
    #define ASSIGN_hsize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_INT
    #define ASSIGN_hsize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_INT
    #define ASSIGN_hsize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_LONG
    #define ASSIGN_hsize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_LONG
    #define ASSIGN_hsize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_INT64_T
    #define ASSIGN_hsize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_INT64_T
    #define ASSIGN_hsize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_hsize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_hsize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_hsize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_hsize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_hsize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_hsize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_hsize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_hsize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_hsize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_hsize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_hsize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_hsize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_hsize_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_hsize_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_hsize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_hsize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_hsize_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_hsize_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSIZE_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_hsize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSIZE_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_hsize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hsize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_hssize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_hssize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_INT8_T
    #define ASSIGN_hssize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_INT8_T
    #define ASSIGN_hssize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_INT
    #define ASSIGN_hssize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_INT
    #define ASSIGN_hssize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_LONG
    #define ASSIGN_hssize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_LONG
    #define ASSIGN_hssize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_INT64_T
    #define ASSIGN_hssize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_INT64_T
    #define ASSIGN_hssize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_hssize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_hssize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_hssize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_hssize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_hssize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_hssize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_hssize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_hssize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_hssize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_hssize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_hssize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_hssize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_hssize_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_hssize_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_hssize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_hssize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_hssize_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_hssize_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_HSSIZE_T < H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_hssize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_HSSIZE_T > H5_SIZEOF_H5_STAT_SIZE_T
    #define ASSIGN_hssize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_hssize_t_TO_h5_stat_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SIGNED_TO_UNSIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_UNSIGNED
    #define ASSIGN_h5_stat_size_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_UNSIGNED
    #define ASSIGN_h5_stat_size_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_unsigned(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_INT8_T
    #define ASSIGN_h5_stat_size_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_INT8_T
    #define ASSIGN_h5_stat_size_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_int8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_INT
    #define ASSIGN_h5_stat_size_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_INT
    #define ASSIGN_h5_stat_size_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_int(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_LONG
    #define ASSIGN_h5_stat_size_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_LONG
    #define ASSIGN_h5_stat_size_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_long(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_INT64_T
    #define ASSIGN_h5_stat_size_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_INT64_T
    #define ASSIGN_h5_stat_size_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_int64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_UINT8_T
    #define ASSIGN_h5_stat_size_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_UINT8_T
    #define ASSIGN_h5_stat_size_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_uint8_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_UINT16_T
    #define ASSIGN_h5_stat_size_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_UINT16_T
    #define ASSIGN_h5_stat_size_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_uint16_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_UINT32_T
    #define ASSIGN_h5_stat_size_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_UINT32_T
    #define ASSIGN_h5_stat_size_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_uint32_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_UINT64_T
    #define ASSIGN_h5_stat_size_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_UINT64_T
    #define ASSIGN_h5_stat_size_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_uint64_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_h5_stat_size_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_PTRDIFF_T
    #define ASSIGN_h5_stat_size_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_ptrdiff_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_SIZE_T
    #define ASSIGN_h5_stat_size_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_SIZE_T
    #define ASSIGN_h5_stat_size_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_size_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_SSIZE_T
    #define ASSIGN_h5_stat_size_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_SSIZE_T
    #define ASSIGN_h5_stat_size_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_ssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_HADDR_T
    #define ASSIGN_h5_stat_size_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_HADDR_T
    #define ASSIGN_h5_stat_size_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_haddr_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_HSIZE_T
    #define ASSIGN_h5_stat_size_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_HSIZE_T
    #define ASSIGN_h5_stat_size_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_hsize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_SAME_SIGNED(dst, dsttype, src, srctype)
#endif 

#if H5_SIZEOF_H5_STAT_SIZE_T < H5_SIZEOF_HSSIZE_T
    #define ASSIGN_h5_stat_size_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_LARGER_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#elif H5_SIZEOF_H5_STAT_SIZE_T > H5_SIZEOF_HSSIZE_T
    #define ASSIGN_h5_stat_size_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SMALLER_SIZE(dst, dsttype, src, srctype)
#else 
    #define ASSIGN_h5_stat_size_t_TO_hssize_t(dst, dsttype, src, srctype) \
        ASSIGN_TO_SAME_SIZE_UNSIGNED_TO_SIGNED(dst, dsttype, src, srctype)
#endif 

#endif 

