% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_logml_post.R
\name{glm.logml.post}
\alias{glm.logml.post}
\title{Log marginal likelihood of a GLM under a normal/half-normal prior}
\usage{
glm.logml.post(post.samples, bridge.args = NULL)
}
\arguments{
\item{post.samples}{output from \code{\link[=glm.post]{glm.post()}} giving posterior samples of a GLM under the normal/half-normal
prior, with an attribute called 'data' which includes the list of variables specified
in the data block of the Stan program.}

\item{bridge.args}{a \code{list} giving arguments (other than \code{samples}, \code{log_posterior}, \code{data}, \code{lb}, and \code{ub}) to
pass onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}
}
\value{
The function returns a \code{list} with the following objects

\describe{
\item{model}{"glm_post"}

\item{logml}{the estimated logarithm of the marginal likelihood}

\item{bs}{an object of class \code{bridge} or \code{bridge_list} containing the output from using \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}
to compute the logarithm of the marginal likelihood of the normal/half-normal prior}
}
}
\description{
Uses bridge sampling to estimate the logarithm of the marginal likelihood of a GLM under the normal/half-normal prior.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg019)
  actg019 = actg019[1:100, ]
  data.list = list(currdata = actg019)
  formula = cd4 ~ treatment + age + race
  family = poisson('log')
  d.post = glm.post(
    formula = formula, family = family,
    data.list = data.list,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
  glm.logml.post(
    post.samples = d.post,
    bridge.args = list(silent = TRUE)
  )
}
}
\references{
Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
