% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfconfig.R
\name{read_prompt}
\alias{read_prompt}
\title{Reads a line from stdin with optional validation and retry logic.}
\usage{
read_prompt(prompt, validate = NULL, attempt = 1, max_attempts = 2)
}
\arguments{
\item{prompt}{Character string shown to the user, e.g. "Enter username: ".}

\item{validate}{Optional function taking a single character argument and
either returning a transformed value or throwing an error if the value
is invalid.}

\item{attempt}{Current attempt number (used internally for recursion).}

\item{max_attempts}{Maximum number of attempts before giving up and
throwing an error.}
}
\value{
The raw input string, or the result of `validate(input)` if
  a validation function is supplied.
}
\description{
This is a small helper used by the GoFigr configuration wizard to collect
user input interactively. When a validation function is supplied, the input
will be repeatedly requested until it passes validation or the maximum
number of attempts is reached.
}
