% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{warn_eigens}
\alias{warn_eigens}
\title{Warn about near-unit-roots in some regimes}
\usage{
warn_eigens(gsmvar, stat_tol = 0.0015, posdef_tol = 2e-04)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{stat_tol}{numerical tolerance for stationarity of the AR parameters: if the "bold A" matrix of any regime
has eigenvalues larger that \code{1 - stat_tol} the model is classified as non-stationary. Note that if the
tolerance is too small, numerical evaluation of the log-likelihood might fail and cause error.}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the model is classified
as not satisfying positive definiteness assumption. Note that if the tolerance is too small, numerical
evaluation of the log-likelihood might fail and cause error.}
}
\value{
Doesn't return anything.
}
\description{
\code{warn_ar_roots} warns if the model contains near-unit-roots in some regimes
}
\details{
Warns if, for some regime, some moduli of "bold A" eigenvalues are larger than \code{1 - stat_tol} or
 some eigenvalue of the error term covariance matrix is smaller than \code{podef_tol}.
}
\keyword{internal}
