% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmSeq.R
\name{glmmSeq}
\alias{glmmSeq}
\title{GLMM with negative binomial distribution for sequencing count data}
\usage{
glmmSeq(
  modelFormula,
  countdata,
  metadata,
  id = NULL,
  dispersion = NA,
  sizeFactors = NULL,
  reduced = NULL,
  modelData = NULL,
  designMatrix = NULL,
  method = c("lme4", "glmmTMB"),
  control = NULL,
  family = nbinom2,
  cores = 1,
  removeSingles = FALSE,
  zeroCount = 0.125,
  verbose = TRUE,
  returnList = FALSE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{modelFormula}{the model formula. This must be of the form \code{"~ ..."}
where the structure is assumed to be \code{"counts ~ ..."}. The formula must
include a random effects term. For more information on formula structure
for random effects see \code{\link[lme4:glmer]{lme4::glmer()}}}

\item{countdata}{the sequencing count data matrix with genes in rows and
samples in columns}

\item{metadata}{a dataframe of sample information with variables in columns
and samples in rows}

\item{id}{Optional. Used to specify the column in metadata which contains the
sample IDs to be used in repeated samples for random effects. If not
specified, the function defaults to using the variable after the "|" in the
random effects term in the formula.}

\item{dispersion}{a numeric vector of gene dispersion. Not required for
\code{glmmTMB} models, as these determine and fit dispersion for each gene.}

\item{sizeFactors}{size factors (default = NULL). If provided the \code{glmer}
offset is set to log(sizeFactors). For more information see``
\code{\link[lme4:glmer]{lme4::glmer()}}}

\item{reduced}{Optional reduced model formula. If this is chosen, a
likelihood ratio test is used to calculate p-values instead of the default
Wald type 2 Chi-squared test.}

\item{modelData}{Optional dataframe. Default is generated by call to
\code{expand.grid} using levels of variables in the formula. Used to calculate
model predictions (estimated means & 95\% CI) for plotting via \link{modelPlot}.
It can therefore be used to add/remove points in \link{modelPlot}.}

\item{designMatrix}{custom design matrix, used only for prediction}

\item{method}{Specifies which package to use for fitting GLMM models. Either
"lme4" or "glmmTMB" depending on whether to use \link[lme4:glmer]{lme4::glmer} or
\link[glmmTMB:glmmTMB]{glmmTMB::glmmTMB} to fit GLMM models.}

\item{control}{the \code{glmer} optimizer control. If \code{method = "lme4"} default is
\code{glmerControl(optimizer = "bobyqa")}). If
\code{method = "glmmTMB"} default is \code{glmmTMBControl()}}

\item{family}{Only used with \code{glmmTMB} models. Default is \code{nbinom2}. See
\link[glmmTMB:nbinom2]{glmmTMB::nbinom2}}

\item{cores}{number of cores to use. Default = 1.}

\item{removeSingles}{whether to remove individuals without repeated measures
(default = FALSE)}

\item{zeroCount}{numerical value to offset zeroes for the purpose of log
(default = 0.125)}

\item{verbose}{Logical whether to display messaging (default = TRUE)}

\item{returnList}{Logical whether to return results as a list or \code{glmmSeq}
object (default = FALSE). Useful for debugging.}

\item{progress}{Logical whether to display a progress bar}

\item{...}{Other parameters to pass to
\code{\link[lme4:glmer]{lme4::glmer()}}}
}
\value{
Returns an S4 class \code{GlmmSeq} object with results for gene-wise
general linear mixed models. A list of results is returned if \code{returnList}
is \code{TRUE} which is useful for debugging. If all genes return errors from
\code{glmer}, then an error message is shown and a character vector containing
error messages for all genes is returned.
}
\description{
Fits many generalised linear mixed effects models (GLMM) with negative
binomial distribution for analysis of overdispersed count data with random
effects. Designed for longitudinal analysis of RNA-Sequencing count data.
}
\details{
This function is a wrapper for \code{\link[lme4:glmer]{lme4::glmer()}}. By default, p-values for each
model term are computed using Wald type 2 Chi-squared test as per
\code{\link[car:Anova]{car::Anova()}}. The underlying code for this has been optimised for speed.
However, if a reduced model formula is specified by setting \code{reduced}, then a
likelihood ratio test is performed instead using \link[stats:anova]{stats::anova}. This will
double computation time since two GLMM have to be fitted.

Parallelisation is provided using \link[parallel:mclapply]{parallel::mclapply} on Unix/Mac or
\link[parallel:clusterApply]{parallel::parLapply} on PC.

Setting \code{method = "glmmTMB"} enables an alternative method of fitting GLMM
using the \code{glmmTMB} package. This gives access to a variety of alternative
GLM family functions. Note, \code{glmmTMB} negative binomial models are
substantially slower to fit than \code{glmer} models with known dispersion due to
the extra time taken by \code{glmmTMB} to optimise the dispersion parameter.

The \code{id} argument is usually optional. By default the \code{id} column in the
metadata is determined as the term after the bar in the random effects term
of the model. Note that \code{id} is not passed to \code{glmer} or \code{glmmTMB}. It is
only really used to remove singletons from the \code{countdata} matrix and
\code{metadata} dataframe. The \code{id} is also stored in the output from \code{glmmSeq}
and used by plotting function \code{\link[=modelPlot]{modelPlot()}}. However, due to its flexible
nature, in theory \code{glmmSeq} should allow for more than one random effect
term, although this has not been tested formally. In this case, it is
probably prudent to specify a value for \code{id}.
}
\examples{
data(PEAC_minimal_load)
disp <- apply(tpm, 1, function(x) {
(var(x, na.rm = TRUE)-mean(x, na.rm = TRUE))/(mean(x, na.rm = TRUE)**2)
})
MS4A1glmm <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     countdata = tpm[1:2, ],
                     metadata = metadata,
                     dispersion = disp,
                     verbose = FALSE)
names(attributes(MS4A1glmm))

}
\seealso{
\link[lme4:glmer]{lme4::glmer} \link[lme4:lmerControl]{lme4::glmerControl} \link[glmmTMB:glmmTMB]{glmmTMB::glmmTMB}
\link[glmmTMB:nbinom2]{glmmTMB::nbinom2} \link[glmmTMB:glmmTMBControl]{glmmTMB::glmmTMBControl} \link[car:Anova]{car::Anova}
}
