% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_legend_interactive.R
\name{guide_legend_interactive}
\alias{guide_legend_interactive}
\title{Create interactive legend guide}
\usage{
guide_legend_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function.}
}
\value{
An interactive guide object.
}
\description{
The guide is based on \code{\link[ggplot2:guide_legend]{ggplot2::guide_legend()}}.
See the documentation for that function for more details.
}
\section{Details for interactive scale and interactive guide functions}{

For scales, the interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors, depending on the number of breaks (levels) and
the type of the guide used.
The guides do not accept any interactive parameter directly, they receive them from the scales.

When guide of type \code{legend}, \code{bins}, \code{colourbar} or \code{coloursteps} is used,
it will be converted to a \code{\link[=guide_legend_interactive]{guide_legend_interactive()}}, \code{\link[=guide_bins_interactive]{guide_bins_interactive()}},
\code{\link[=guide_colourbar_interactive]{guide_colourbar_interactive()}} or \code{\link[=guide_coloursteps_interactive]{guide_coloursteps_interactive()}} respectively,
if it's not already.

The length of each scale interactive parameter vector should match the length of the breaks.
It can also be a named vector, where each name should correspond to the same break name.
It can also be defined as function that takes the breaks as input and returns a named or
unnamed vector of values as output.

For binned guides like \code{bins} and \code{coloursteps} the breaks include the label breaks and the limits.
The number of bins will be one less than the number of breaks and the interactive parameters can be
constructed for each bin separately (look at the examples).
For \code{colourbar} guide in raster mode, the breaks vector, is scalar 1 always, meaning the interactive
parameters should be scalar too. For \code{colourbar} guide in non-raster mode, the bar is drawn using
rectangles, and the breaks are the midpoints of each rectangle.

The interactive parameters here, give interactivity only to the key elements of the guide.

To provide interactivity to the rest of the elements of a guide, (title, labels, background, etc),
the relevant theme elements or relevant guide arguments can be used.
The \code{guide} arguments \code{title.theme} and \code{label.theme} can be defined as
\code{element_text_interactive} (in fact, they will be converted to that if they are not
already), either directly or via the theme.
See the element_*_interactive section for more details.
}

\examples{
# add interactive discrete legend guide to a ggplot -------
library(ggplot2)
library(ggiraph)

dat <- data.frame(
  name = c("Guy", "Ginette", "David", "Cedric", "Frederic"),
  gender = c("Male", "Female", "Male", "Male", "Male"),
  height = c(169, 160, 171, 172, 171)
)
p <- ggplot(dat, aes(x = name, y = height, fill = gender, data_id = name)) +
  geom_bar_interactive(stat = "identity")

# add interactive scale (guide is legend)
p1 <- p +
  scale_fill_manual_interactive(
    values = c(Male = "#0072B2", Female = "#009E73"),
    data_id = c(Female = "Female", Male = "Male"),
    tooltip = c(Male = "Male", Female = "Female")
  )
x <- girafe(ggobj = p1)
if (interactive()) {
  print(x)
}

# make the title interactive too
p2 <- p +
  scale_fill_manual_interactive(
    name = label_interactive(
      "gender",
      tooltip = "Gender levels",
      data_id = "legend.title"
    ),
    values = c(Male = "#0072B2", Female = "#009E73"),
    data_id = c(Female = "Female", Male = "Male"),
    tooltip = c(Male = "Male", Female = "Female")
  )
x <- girafe(ggobj = p2)
x <- girafe_options(
  x,
  opts_hover_key(girafe_css("stroke:red", text = "stroke:none;fill:red"))
)
if (interactive()) {
  print(x)
}

# the interactive params can be functions too
p3 <- p +
  scale_fill_manual_interactive(
    name = label_interactive(
      "gender",
      tooltip = "Gender levels",
      data_id = "legend.title"
    ),
    values = c(Male = "#0072B2", Female = "#009E73"),
    data_id = function(breaks) {
      as.character(breaks)
    },
    tooltip = function(breaks) {
      as.character(breaks)
    },
    onclick = function(breaks) {
      paste0("alert(\"", as.character(breaks), "\")")
    }
  )
x <- girafe(ggobj = p3)
x <- girafe_options(
  x,
  opts_hover_key(girafe_css("stroke:red", text = "stroke:none;fill:red"))
)
if (interactive()) {
  print(x)
}

# also via the guide
p4 <- p +
  scale_fill_manual_interactive(
    values = c(Male = "#0072B2", Female = "#009E73"),
    data_id = function(breaks) {
      as.character(breaks)
    },
    tooltip = function(breaks) {
      as.character(breaks)
    },
    onclick = function(breaks) {
      paste0("alert(\"", as.character(breaks), "\")")
    },
    guide = guide_legend_interactive(
      title.theme = element_text_interactive(
        size = 8,
        data_id = "legend.title",
        onclick = "alert(\"Gender levels\")",
        tooltip = "Gender levels"
      ),
      label.theme = element_text_interactive(
        size = 8
      )
    )
  )
x <- girafe(ggobj = p4)
x <- girafe_options(
  x,
  opts_hover_key(girafe_css("stroke:red", text = "stroke:none;fill:red"))
)
if (interactive()) {
  print(x)
}

# make the legend labels interactive
p5 <- p +
  scale_fill_manual_interactive(
    name = label_interactive(
      "gender",
      tooltip = "Gender levels",
      data_id = "legend.title"
    ),
    values = c(Male = "#0072B2", Female = "#009E73"),
    data_id = function(breaks) {
      as.character(breaks)
    },
    tooltip = function(breaks) {
      as.character(breaks)
    },
    onclick = function(breaks) {
      paste0("alert(\"", as.character(breaks), "\")")
    },
    labels = function(breaks) {
      lapply(breaks, function(br) {
        label_interactive(
          as.character(br),
          data_id = as.character(br),
          onclick = paste0("alert(\"", as.character(br), "\")"),
          tooltip = as.character(br)
        )
      })
    }
  )
x <- girafe(ggobj = p5)
x <- girafe_options(
  x,
  opts_hover_key(girafe_css("stroke:red", text = "stroke:none;fill:red"))
)
if (interactive()) {
  print(x)
}
# add interactive continuous legend guide to a ggplot -------
library(ggplot2)
library(ggiraph)

set.seed(4393)
dsmall <- diamonds[sample(nrow(diamonds), 1000), ]
p <- ggplot(dsmall, aes(x, y)) +
  stat_density_2d(
    aes(
      fill = after_stat(nlevel),
      tooltip = paste("nlevel:", after_stat(nlevel))
    ),
    geom = "interactive_polygon"
  ) +
  facet_grid(. ~ cut)

# add interactive scale, by default the guide is a colourbar
p1 <- p +
  scale_fill_viridis_c_interactive(data_id = "nlevel", tooltip = "nlevel")
x <- girafe(ggobj = p1)
if (interactive()) {
  print(x)
}

# make it legend
p2 <- p +
  scale_fill_viridis_c_interactive(
    data_id = "nlevel",
    tooltip = "nlevel",
    guide = "legend"
  )
x <- girafe(ggobj = p2)
if (interactive()) {
  print(x)
}

# set the keys separately
p3 <- p +
  scale_fill_viridis_c_interactive(
    data_id = function(breaks) {
      as.character(breaks)
    },
    tooltip = function(breaks) {
      as.character(breaks)
    },
    guide = "legend"
  )
x <- girafe(ggobj = p3)
if (interactive()) {
  print(x)
}


# make the title and labels interactive
p4 <- p +
  scale_fill_viridis_c_interactive(
    data_id = function(breaks) {
      as.character(breaks)
    },
    tooltip = function(breaks) {
      as.character(breaks)
    },
    guide = "legend",
    name = label_interactive("nlevel", data_id = "nlevel", tooltip = "nlevel"),
    labels = function(breaks) {
      label_interactive(
        as.character(breaks),
        data_id = as.character(breaks),
        onclick = paste0("alert(\"", as.character(breaks), "\")"),
        tooltip = as.character(breaks)
      )
    }
  )
x <- girafe(ggobj = p4)
x <- girafe_options(
  x,
  opts_hover_key(girafe_css("stroke:red", text = "stroke:none;fill:red"))
)
if (interactive()) {
  print(x)
}
}
\seealso{
\link{interactive_parameters}, \code{\link[=girafe]{girafe()}}
}
