% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-freqpoly-sample.R,
%   R/geom-histogram-sample.R, R/stat-bin-sample.R
\docType{data}
\name{geom_freqpoly_sample}
\alias{geom_freqpoly_sample}
\alias{geom_histogram_sample}
\alias{StatBinSample}
\alias{stat_bin_sample}
\title{Histograms and frequency polygons with uncertainty}
\usage{
geom_freqpoly_sample(
  mapping = NULL,
  data = NULL,
  stat = "bin_sample",
  position = "identity",
  ...,
  na.rm = FALSE,
  times = 10,
  seed = NULL,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_histogram_sample(
  mapping = NULL,
  data = NULL,
  stat = "bin_sample",
  position = "stack_dodge",
  ...,
  times = 10,
  seed = NULL,
  binwidth = NULL,
  bins = NULL,
  orientation = NA,
  lineend = "butt",
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_bin_sample(
  mapping = NULL,
  data = NULL,
  geom = "bar",
  position = "stack_dodge",
  ...,
  times = 10,
  orientation = NA,
  seed = NULL,
  binwidth = NULL,
  bins = NULL,
  center = NULL,
  boundary = NULL,
  closed = c("right", "left"),
  pad = FALSE,
  breaks = NULL,
  drop = "none",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{times}{A parameter used to control the number of values sampled from 
each distribution.}

\item{seed}{Set the seed for the layers random draw, allows you to plot the
same draw across multiple layers.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that takes x after scale transformation as input and
returns a single numeric value. When specifying a function along with a
grouping structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{geom, stat}{Use to override the default connection between
\code{geom_histogram()}/\code{geom_freqpoly()} and \code{stat_bin()}. For more information
at overriding these connections, see how the \link[ggplot2:layer_stats]{stat} and
\link[ggplot2:layer_geoms]{geom} arguments work.}

\item{center, boundary}{bin position specifiers. Only one, \code{center} or
\code{boundary}, may be specified for a single plot. \code{center} specifies the
center of one of the bins. \code{boundary} specifies the boundary between two
bins. Note that if either is above or below the range of the data, things
will be shifted by the appropriate integer multiple of \code{binwidth}.
For example, to center on integers use \code{binwidth = 1} and \code{center = 0}, even
if \code{0} is outside the range of the data. Alternatively, this same alignment
can be specified with \code{binwidth = 1} and \code{boundary = 0.5}, even if \code{0.5} is
outside the range of the data.}

\item{closed}{One of \code{"right"} or \code{"left"} indicating whether right
or left edges of bins are included in the bin.}

\item{pad}{If \code{TRUE}, adds empty bins at either end of x. This ensures
frequency polygons touch 0. Defaults to \code{FALSE}.}

\item{breaks}{Alternatively, you can supply a numeric vector giving
the bin boundaries. Overrides \code{binwidth}, \code{bins}, \code{center},
and \code{boundary}. Can also be a function that takes group-wise values as input and returns bin boundaries.}

\item{drop}{Treatment of zero count bins. If \code{"none"} (default), such
bins are kept as-is. If \code{"all"}, all zero count bins are filtered out.
If \code{"extremes"} only zero count bins at the flanks are filtered out, but
not in the middle. \code{TRUE} is shorthand for \code{"all"} and \code{FALSE} is shorthand
for \code{"none"}.}
}
\value{
A ggplot2 layer
}
\description{
Identical to geom_histogram, geom_freqpoly, and stat-bin except that 
it will accept a distribution in place of any of the usual aesthetics.
}
\examples{
# load ggplot
library(ggplot2)
# ggplot
ggplot(smaller_diamonds, aes(carat)) +
  geom_histogram()
# ggdibbler
ggplot(smaller_uncertain_diamonds, aes(carat)) +
  geom_histogram_sample() #' alpha
ggplot(smaller_uncertain_diamonds, aes(carat)) +
  geom_histogram_sample(position="identity_identity", alpha=0.15) 

# ggplot
ggplot(smaller_diamonds, aes(price, colour = cut)) +
  geom_freqpoly(binwidth = 500)
# ggdibbler
ggplot(smaller_uncertain_diamonds, aes(price, colour = cut)) +
  geom_freqpoly_sample(binwidth = 500)
 
# ggplot2
ggplot(smaller_diamonds, aes(price, fill = cut)) +
  geom_histogram(binwidth = 500)
# ggdibbler
ggplot(smaller_uncertain_diamonds, aes(price, fill = cut)) +
 geom_histogram_sample(binwidth = 500)


}
\keyword{datasets}
