% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-boxplot-sample.R, R/stat-boxplot-sample.R
\docType{data}
\name{geom_boxplot_sample}
\alias{geom_boxplot_sample}
\alias{StatBoxplotSample}
\alias{stat_boxplot_sample}
\title{An uncertain box and whiskers plot (in the style of Tukey)}
\usage{
geom_boxplot_sample(
  mapping = NULL,
  data = NULL,
  times = 10,
  seed = NULL,
  stat = "boxplot_sample",
  position = "identity",
  ...,
  outliers = TRUE,
  outlier.colour = NULL,
  outlier.color = NULL,
  outlier.fill = NULL,
  outlier.shape = NULL,
  outlier.size = NULL,
  outlier.stroke = 0.5,
  outlier.alpha = NULL,
  whisker.colour = NULL,
  whisker.color = NULL,
  whisker.linetype = NULL,
  whisker.linewidth = NULL,
  staple.colour = NULL,
  staple.color = NULL,
  staple.linetype = NULL,
  staple.linewidth = NULL,
  median.colour = NULL,
  median.color = NULL,
  median.linetype = NULL,
  median.linewidth = NULL,
  box.colour = NULL,
  box.color = NULL,
  box.linetype = NULL,
  box.linewidth = NULL,
  notch = FALSE,
  notchwidth = 0.5,
  staplewidth = 0,
  varwidth = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_boxplot_sample(
  mapping = NULL,
  data = NULL,
  geom = "boxplot",
  position = "identity",
  ...,
  times = 10,
  orientation = NA,
  seed = NULL,
  coef = 1.5,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{times}{A parameter used to control the number of values sampled from each distribution.}

\item{seed}{Set the seed for the layers random draw, allows you to plot the
same draw across multiple layers.}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{outliers}{Whether to display (\code{TRUE}) or discard (\code{FALSE}) outliers
from the plot. Hiding or discarding outliers can be useful when, for
example, raw data points need to be displayed on top of the boxplot.
By discarding outliers, the axis limits will adapt to the box and whiskers
only, not the full data range. If outliers need to be hidden and the axes
needs to show the full data range, please use \code{outlier.shape = NA} instead.}

\item{outlier.colour, outlier.color, outlier.fill, outlier.shape, outlier.size, outlier.stroke, outlier.alpha}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{whisker.colour, whisker.color, whisker.linetype, whisker.linewidth}{Default aesthetics for the whiskers. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{staple.colour, staple.color, staple.linetype, staple.linewidth}{Default aesthetics for the staples. Set to \code{NULL} to inherit from the
data's aesthetics. Note that staples don't appear unless the \code{staplewidth}
argument is set to a non-zero size.}

\item{median.colour, median.color, median.linetype, median.linewidth}{Default aesthetics for the median line. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{box.colour, box.color, box.linetype, box.linewidth}{Default aesthetics for the boxes. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{notch}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{For a notched box plot, width of the notch relative to
the body (defaults to \code{notchwidth = 0.5}).}

\item{staplewidth}{The relative width of staples to the width of the box.
Staples mark the ends of the whiskers with a line.}

\item{varwidth}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_boxplot()} and \code{stat_boxplot()}. For more information about
overriding these connections, see how the \link[ggplot2:layer_stats]{stat} and
\link[ggplot2:layer_geoms]{geom} arguments work.}

\item{coef}{Length of the whiskers as multiple of IQR. Defaults to 1.5.}
}
\value{
A ggplot2 layer
}
\description{
Identical to geom_boxplot, except that it will accept a distribution in place of any of the usual aesthetics.
}
\examples{
library(ggplot2)
# ggplot
p <- ggplot(mpg, aes(class, hwy))
p + geom_boxplot(alpha=0.5)

# using alpha to manage overplotting
q <- ggplot(uncertain_mpg, aes(class, hwy)) 
q + geom_boxplot_sample(alpha=0.1) 

# ggplot
p + geom_boxplot(varwidth = TRUE)
# ggdibbler
q + geom_boxplot_sample(alpha=0.1, varwidth = TRUE) 

# ggplot
p + geom_boxplot(aes(colour = drv), position = position_dodge(preserve = "single"))
# ggdibbler
q + geom_boxplot_sample(aes(colour = drv), alpha=0.05, position = "dodge_identity")

}
\keyword{datasets}
