% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipses.R
\name{ob_ellipse}
\alias{ob_ellipse}
\title{ob_ellipse class}
\usage{
ob_ellipse(
  center = ob_point(0, 0),
  a = 1,
  b = a,
  angle = 0,
  m1 = numeric(0),
  m2 = numeric(0),
  label = character(0),
  alpha = numeric(0),
  color = character(0),
  fill = character(0),
  linewidth = numeric(0),
  linetype = numeric(0),
  n = numeric(0),
  style = S7::class_missing,
  x = numeric(0),
  y = numeric(0),
  id = character(0),
  ...
)
}
\arguments{
\item{center}{point at center of ellipse. \emph{Settable.}}

\item{a}{distance of semi-major axis. \emph{Settable.}}

\item{b}{distance of semi-minor axis. \emph{Settable.}}

\item{angle}{ellipse rotation. \emph{Settable.}}

\item{m1}{exponent of semi-major axis. \emph{Settable.} Controls roundedness of superellipse}

\item{m2}{exponent of semi-minor axis. \emph{Settable.} By default equal to \code{m1}. If different, some functions may not work as expected (e.g., \code{point_at}).}

\item{label}{A character, angle, or label object}

\item{alpha}{numeric value for alpha transparency}

\item{color}{character string for color}

\item{fill}{character string for fill color}

\item{linewidth}{Width of lines}

\item{linetype}{type of lines}

\item{n}{number of points in ellipse (default = 360). \emph{Settable.}}

\item{style}{gets and sets style parameters}

\item{x}{x-coordinate of center point. If specified, overrides x-coordinate of \verb{@center}.}

\item{y}{x-coordinate of center point. If specified, overrides y-coordinate of \verb{@center}.}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> properties passed to style object}
}
\value{
ob_ellipse object
}
\description{
Makes ellipses and superellipses
}
\section{Slots}{

\describe{
\item{\code{length}}{Gets the number of ellipses}

\item{\code{tibble}}{Gets a tibble (data.frame) containing parameters and styles used by \code{ggforce::geom_ellipse}.}

\item{\code{geom}}{A function that converts the object to a geom. Any additional parameters are passed to \code{ggforce::geom_ellipse}.}

\item{\code{normal_at}}{A function that finds a point perpendicular to the ellipse at angle \code{theta} at the specified \code{distance}. The \code{definitional} parameter is passed to the \code{point_at} function. If a point is supplied instead of an angle, the point is projected onto the ellipse and then the normal is calculated found from the projected point.}

\item{\code{point_at}}{A function that finds a point on the ellipse at an angle \code{theta}. If \code{definitional} is \code{FALSE} (default), then \code{theta} is interpreted as an angle. If \code{TRUE}, then \code{theta} is the parameter in the definition of the ellipse in polar coordinates.}

\item{\code{tangent_at}}{A function that finds a tangent line on the ellipse. Uses \code{point_at} to find the tangent point at angle \code{theta} and then returns the tangent line at that point. If a point is supplied instead of an angle, the point is projected onto the ellipse and then the tangent line is found from there.}
}}

\examples{
# specify center point and semi-major axes
e <- ob_ellipse(center = ob_point(0,0), a = 2, b = 3)
ggdiagram() +
  e
}
