% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{testBots}
\alias{testBots}
\title{Simulate many games of Four in a Row}
\usage{
testBots(playerOne, playerTwo, n = 100)
}
\arguments{
\item{playerOne}{A function that takes the current board as input and returns
the next move (1-7) for Player 1.}

\item{playerTwo}{Same for Player 2. Note that both functions see their pieces
as "X" and opponent's pieces as "O".}

\item{n}{Numerical value of how many games to simulate. Must be an even
number, so that both bots get the same number of games with the first move
(default = 100).}
}
\value{
Returns a vector of counts for the number of \code{ties}, wins by
  \code{playerOne}, and wins by \code{playerTwo}.
}
\description{
This is a convenient way to test two bots against each other over a large
number of games while ensuring that neither bot has an advantage from going
first more often than the other.
}
\examples{
testBots(easyBot, randomBot)

}
