% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSystemModel.R
\name{runSystemModel}
\alias{runSystemModel}
\title{Runs a system model and outputs the system performance}
\usage{
runSystemModel(sim, systemModel, systemArgs, metrics, varNames = NULL)
}
\arguments{
\item{sim}{list; a simulation containing the scenarios generated using the function \code{generateScenarios}.}

\item{systemModel}{a function; The function runs the system model using climate data in a list as input.
The function is expected to be created by the user for specific system models. \code{tankWrapper} is an example system model function available in this package.
\code{runSystemModel} calls the function \code{systemModel} with two arguments:
\itemize{
\item \code{data}: list; the climate data as a list in reference format, with POSIXct formatted \emph{times} and climate variables \emph{*variable_name1*} \emph{*variable_name2*} in vector or matrix.
\item \code{systemArgs}: list; containing the other arguments required by the system model.\code{systemModel} unpack the arguments from the list and uses them as required.
\item \code{metrics}: string vector; containing the names of the performance metrics that the system model returns. It is recommended that the
names also contain the units of the metric. See \code{viewTankMetrics()} for examples.
}}

\item{systemArgs}{a list; containing the input arguments to \code{systemModel}.}

\item{metrics}{a string vector; the names of the performance metrics the \code{systemModel} function returns.}

\item{varNames}{a string vector; containing the names of the climate variables that are extracted from sim and used in system model. If \code{NULL}, then \code{varNames} determined from attribute names in \code{sim$expSpace}.}
}
\value{
The function returns a list containing the performance metrics calculated by the \code{systemModel}. Each element of the list corresponds to a performance metric and is named using the \code{metrics} argument.
Each element contains performance values calculated at all the target points in the exposure space in a matrix with nrow corresponding to the targets and ncol corresponding to the replicates.
}
\description{
\code{runSystemModel} uses time series of hydroclimatic variables generated using the function \code{generateScenarios} as input to a systemModel and
collates the system performance for all the targets and replicates in the scenarios.
}
\details{
The \code{runSystemModel} function code is structured to be simple and may be used as an example to create scripts that use scenarios
generated using \code{generateScenarios} to run system models in other programming languages. Type \code{runSystemModel} to view the function code.
The function \code{tankWrapper} in this package may be used as an example to create user defined functions for the \code{systemModel} argument.
Refer to \code{tankWrapper} to understand how the \code{systemModel} is expected to use \code{systemArgs} and return the calculated performance metrics.
The \code{systemModel} function is expected to return a named list of performance metrics. The elements of the vector should correspond to \code{metrics}.
}
\examples{
\dontrun{
# Example using tankWrapper as the systemModel
# =====================================================
# create an exposure space
attPerturb <- c("P_day_all_tot", "Temp_day_all_avg")
attPerturbType <- "regGrid"
attPerturbSamp <- c(10, 10)
attPerturbMin <- c(0.8, -1)
attPerturbMax <- c(1.2, 1)
expSpace <- createExpSpace(
  attPerturb = attPerturb,
  attPerturbSamp = attPerturbSamp,
  attPerturbMin = attPerturbMin,
  attPerturbMax = attPerturbMax,
  attPerturbType = attPerturbType
)
data(tankDat)
simScaling <- generateScenarios(
  reference = tank_obs,
  expSpace = expSpace,
  controlFile = "scaling"
)
# use the simulation to run a system model
systemArgs <- list(
  roofArea = 205, nPeople = 1, tankVol = 2400,
  firstFlush = 2.0, write.file = FALSE
)
tankMetrics <- viewTankMetrics()
systemPerf <- runSystemModel(
  sim = simScaling,
  systemModel = tankWrapper,
  systemArgs = systemArgs,
  metrics = tankMetrics[1:2]
)
}
}
\seealso{
\code{tankWrapper}, \code{generateScenarios}
}
