% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{accessors}
\alias{accessors}
\alias{get_ymd}
\alias{get_year}
\alias{get_month}
\alias{get_mday}
\title{Generics for accessing the year, month and month-day of an object}
\usage{
get_ymd(x, ...)

get_year(x, ...)

get_month(x, ...)

get_mday(x, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
For \code{get_ymd()} a data frame with integer columns year, month and mday. For
\code{get_year()}, \code{get_month()} and \code{get_mday()}, integer vectors of the
requested components.
}
\description{
Fast methods are provided for \code{Date} objects. The underlying algorithm
follows the approach described in Hinnant (2021) for converting days since
the \href{https://en.wikipedia.org/wiki/Unix_time}{UNIX Epoch} to \href{https://en.wikipedia.org/wiki/Gregorian_calendar}{Gregorian Calendar} dates.
}
\examples{
date <- as.Date("2025-04-17")
get_ymd(date)
get_year(date)
get_month(date)
get_mday(date)

}
\references{
Hinnant, J. (2021) \emph{chrono-Compatible Low-Level Date Algorithms}.
Available at: \url{https://howardhinnant.github.io/date_algorithms.html#civil_from_days}
(Accessed 17 April 2025).
}
