% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{loglik_poisson_nmf}
\alias{loglik_poisson_nmf}
\alias{loglik_multinom_topic_model}
\alias{deviance_poisson_nmf}
\alias{cost}
\title{NMF and Topic Model Likelihoods and Deviances}
\usage{
loglik_poisson_nmf(X, fit, e = 1e-08)

loglik_multinom_topic_model(X, fit, e = 1e-08)

deviance_poisson_nmf(X, fit, e = 1e-08)

cost(X, A, B, e = 1e-08, family = c("poisson", "multinom"), version)
}
\arguments{
\item{X}{The n x m matrix of counts or pseudocounts. It can be a
sparse matrix (class \code{"dgCMatrix"}) or dense matrix (class
\code{"matrix"}).}

\item{fit}{A Poisson NMF or multinomial topic model fit, such as an
output from \code{\link{fit_poisson_nmf}} or
\code{\link{fit_topic_model}}.}

\item{e}{A small, non-negative number added to the terms inside the
logarithms to avoid computing logarithms of zero. This prevents
numerical problems at the cost of introducing a very small
inaccuracy in the computation.}

\item{A}{The n x k matrix of loadings. It should be a dense matrix.}

\item{B}{The k x m matrix of factors. It should be a dense matrix.}

\item{family}{If \code{model = "poisson"}, the loss function values
corresponding to the Poisson non-negative matrix factorization are
computed; if \code{model = "multinom"}, the multinomial topic model
loss function values are returned.}

\item{version}{When \code{version == "R"}, the computations are
performed entirely in R; when \code{version == "Rcpp"}, an Rcpp
implementation is used. The R version is typically faster when
\code{X} is a dense matrix, whereas the Rcpp version is faster and
more memory-efficient when \code{X} is a large, sparse matrix. When
not specified, the most suitable version is called depending on
whether \code{X} is dense or sparse.}
}
\value{
A numeric vector with one entry per row of \code{X}.
}
\description{
Compute log-likelihoods and deviances for assessing
  fit of a topic model or a non-negative matrix factorization (NMF).
}
\details{
Function \code{cost} computes loss functions proportional
  to the negative log-likelihoods, and is mainly for internal use to
  quickly compute log-likelihoods and deviances; it should not be
  used directly unless you know what you are doing. In particular,
  little argument checking is performed by \code{cost}.
}
\examples{

# Generate a small counts matrix.
set.seed(1)
out <- simulate_count_data(10,20,3)
X   <- out$X
fit <- out[c("F","L")]
class(fit) <- c("poisson_nmf_fit","list")

# Compute the Poisson log-likelihoods and deviances.
data.frame(loglik   = loglik_poisson_nmf(X,fit),
           deviance = deviance_poisson_nmf(X,fit))

# Compute multinomial log-likelihoods.
loglik_multinom_topic_model(X,fit)

}
