% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions.R
\name{uscore}
\alias{uscore}
\alias{nscore}
\alias{rpscore}
\title{Rank-based Scores}
\usage{
uscore(x, pos = "Hazen", na.rm = FALSE)

nscore(x, pos = "Hazen", na.rm = FALSE)

rpscore(x, pos = "Hazen", na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{pos}{Positional adjustment for uniform scores. See Details.
Can be a single numeric, or could be named after one of the
proponents behind a choice of the numeric: "Weibull", "Beard",
"Gringorten", or "Hazen".}

\item{na.rm}{Logical indicating whether \code{NA} and \code{NaN} values should be
removed from the output.}
}
\value{
Vector of uniform scores corresponding to values in \code{x}.
}
\description{
Converts a numeric vector to its rank-based scores. For \code{uscore()}
(uniform scores), values become roughly equally spaced between 0 and 1,
keeping their order. \code{nscore()} calculates normal scores by
spacing the uniform scores along a standard
normal distribution; \code{rpscore()} calculates empirical return periods
by spacing the uniform scores \code{u} by \code{1 / (1 - u)}.
}
\details{
Uniform scores are calculated by \code{(rank+a)/(n+1+2*a)},
where \code{rank} is the ranked \code{x} values, and \code{a} is the positional
adjustment \code{pos}. Alternatively, could be named after an individual
associated with a choice of \code{a}:
\itemize{
\item Weibull (1939) proposed \code{a = 0}.
\item Beard (1943) proposed \code{a = -0.31}.
\item Gringorten (1963) proposed \code{a = -0.44}.
\item Hazen (1914) proposed \code{a = -0.5}.
}
}
\examples{
x <- c(0.3, 0.56, NA, 0.1, -12)
uscore(x)
uscore(x, pos = "Gringorten")
nscore(x, pos = -0.4)
rpscore(x)

}
\references{
Beard, L. R. (1943). Statistical analysis in hydrology. \emph{Transactions of the
American Society of Civil Engineers}, 108, 1110–1160.

Gringorten, I. I. (1963). A plotting rule for extreme probability paper.
\emph{Journal of Geophysical Research}, 68(3), 813–814.

Hazen, A. (1914). Storage to be provided in impounding reservoirs for
municipal water supply. \emph{Transactions of the American Society of Civil
Engineers}, 77, 1539–1640.

Weibull, W. (1939). A statistical theory of the strength of materials.
\emph{IVB-Handl.}, 151.
}
\author{
Thanks to Dr. Harry Joe for providing a starting framework for
the \code{uscore()} function.
}
