% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGFgamma.R
\name{MGFgamma}
\alias{MGFgamma}
\title{Evaluate the moment generating function (MGF) of the gamma distribution or a derivative of the MGF}
\usage{
MGFgamma(x, rate, shape, deriv = 0)
}
\arguments{
\item{x}{The value at which to evaluate the MGF}

\item{rate}{The rate parameter value of the gamma distribution}

\item{shape}{The shape parameter values of the gamma distribution}

\item{deriv}{An integer, the number of derivatives of the MGF to apply}
}
\value{
The number resulting from the function evaluation
}
\description{
Evaluate the moment generating function (MGF) of the gamma distribution or a derivative of the MGF
}
\examples{
# MGF of a gamma distributions, evaluated at -0.1:
MGFgamma(-0.1, rate = 0.7, shape = 3)
# Second moment of the distribution (second derivative evaluated at zero):
MGFgamma(0, rate = 0.7, shape = 3, deriv = 2)
}
