% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-database.R
\name{write_csv_and_db}
\alias{write_csv_and_db}
\title{Write data to CSV and/or database (helper function)}
\usage{
write_csv_and_db(
  data,
  csv_path,
  csv_enabled = TRUE,
  db_con = NULL,
  data_type = NULL,
  sub = NULL,
  ses = NULL,
  task = NULL,
  run = NULL,
  eye_suffix = NULL,
  epoch_label = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame to write}

\item{csv_path}{Full path where CSV file should be written (ignored if csv_enabled = FALSE)}

\item{csv_enabled}{Whether to write CSV files (defaults to TRUE for backward compatibility)}

\item{db_con}{Database connection (NULL if not enabled)}

\item{data_type}{Type of data ("timeseries", "epochs", "epoch_timeseries", "epoch_summary", "events", "blinks", "confounds")}

\item{sub}{Subject ID}

\item{ses}{Session ID}

\item{task}{Task name}

\item{run}{Run number (optional)}

\item{eye_suffix}{Eye suffix for binocular data (optional)}

\item{epoch_label}{Epoch label for epoched data (optional, used in table naming)}

\item{verbose}{Whether to print verbose output}
}
\value{
Logical indicating success
}
\description{
This helper function writes data to CSV files and/or database based on the
configuration. Useful for large-scale cloud compute where CSV files may be
unnecessary when using database storage.
}
\keyword{internal}
