% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore_col}
\alias{explore_col}
\title{Explore data without aggregation (label + value)}
\usage{
explore_col(
  data,
  var_label,
  var_value,
  title = NA,
  subtitle = "",
  numeric = FALSE,
  max_cat = 30,
  na = 0,
  flip = NA,
  color = "#ADD8E6"
)
}
\arguments{
\item{data}{A dataset (categories + frequency)}

\item{var_label}{Variable containing the label}

\item{var_value}{Variable containing the value}

\item{title}{Title of the plot}

\item{subtitle}{Subtitle of the plot}

\item{numeric}{Display variable as numeric (not category)}

\item{max_cat}{Maximum number of categories to be plotted}

\item{na}{Value to use for NA}

\item{flip}{Flip plot? (for categorical variables)}

\item{color}{Color for bar}
}
\value{
Plot object
}
\description{
Label and Value are in the data. Create a bar plot where the heights of the
bars represent the values for each label.
}
\examples{
library(magrittr)
data <- data.frame(label = LETTERS[1:5], value = c(1.5,2,1.2,3,2.6))
data \%>\% explore_col(label, value)

}
