% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{JSR}
\alias{JSR}
\title{Joint Selection Rate}
\usage{
JSR(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A list of Joint Selection Rate matrices for each item pair.
}
\description{
Calculate the Joint Selection Rate (JSR) for polytomous data.
JSR measures the proportion of respondents who selected specific category
combinations between pairs of items. For each pair of items (j,k),
it returns a contingency table showing the joint probability of selecting
each category combination.
}
\examples{
# example code
# Calculate JCRR using sample dataset J5S1000
JSR(J5S1000)
}
