% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{CCRR}
\alias{CCRR}
\alias{CCRR.default}
\alias{CCRR.binary}
\alias{CCRR.nominal}
\title{Conditional Correct Response Rate}
\usage{
CCRR(U, na = NULL, Z = NULL, w = NULL)

\method{CCRR}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{CCRR}{binary}(U, na = NULL, Z = NULL, w = NULL)

\method{CCRR}{nominal}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A matrix of conditional correct response rates with exametrika class.
Each element (i,j) represents the probability of correctly answering item j
given that item i was answered correctly.
}
\description{
The conditional correct response rate (CCRR) represents the ratio of the students
who passed Item C (consequent item) to those who passed Item A (antecedent item).
This function is applicable only to binary response data.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate CCRR using sample dataset J5S10
CCRR(J5S10)
}
