% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energyGOF.R
\name{f_dist}
\alias{f_dist}
\title{Create an F distribution object for energy testing}
\usage{
f_dist(df1 = 3, df2 = 3)
}
\arguments{
\item{df1}{Positive.}

\item{df2}{Must be greater than 2.}
}
\value{
S3 data object containing the following fields.
\itemize{
\item \code{name}: String
\item \code{composite_p}: Composite predicate. TRUE if test is composite.
\item \code{par}: Distribution parameters, list of the formals.
\item \code{sampler_par}: Distribution parameters used for the calculation of energy
statistic. These may be different than \code{par}.
\item \code{par_domain}: Function used to ensure \code{par} and \code{sampler_par} are valid for
this distribution
\item \code{support}: Function to check that data \code{x} can be tested against \code{y}
\item \code{sampler}: Function used for rng by \code{\link[boot:boot]{boot::boot()}}
\item \code{EYY}: Function to compute \eqn{E|Y-Y'|} (or \eqn{E|Y-Y'|^{pow}}, for the
generalized test.)
\item \code{EXYhat}: Function to compute \eqn{\frac{1}{n} \sum_i E|x_i - Y|} (or
\eqn{\frac{1}{n} \sum_i E|x_i - Y|^{pow}}), where Y is distributed according
to \code{y} and x is the data under test (which is passed in \code{egof.test} or \code{egofd}).
\item \code{xform}: Function that may be used to transform x. Only available in certain
distribution objects.
\item \code{statistic}: Function that returns a list of maximum likelihood estimates.
Only available in certain distribution objects.
\item \code{notes}: Distribution specific messages. Only used in certain distribution
objects.
}

\emph{Note}: Some distributions do not have notes, xform, and statistic fields.
This is because either a composite test is not implemented, or because a
data transformation is not needed.
}
\description{
Create an S3 object that sets all the required data needed by
energyGOFdist to execute the energy goodness-of-fit test against a F
distribution. Only simple tests are supported.
}
\examples{

d <- f_dist(3, 3)
egofd(rf(10, 3, 3), d, 0)

}
\author{
John T. Haman
}
