% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energyGOF.R
\name{energyGOFdist}
\alias{energyGOFdist}
\alias{egofd}
\title{S3 Interface to Parametric Goodness-of-Fit Tests via Energy}
\usage{
energyGOFdist(x, dist, nsim)

egofd(x, dist, nsim)
}
\arguments{
\item{x}{A numeric vector.}

\item{dist}{An object of class GOFDist. The distribution to test \code{x}
against. GOFDist objects are created with the various "*_dist()"
functions in this package. See, for example, \code{\link[=normal_dist]{normal_dist()}} for details
on these class objects.}

\item{nsim}{A non-negative integer. The number of parametric bootstrap
replicates taken to calculate the \emph{p}-value. If 0, no simulation.}
}
\value{
Return an object of class `htest'
representing the result of the energy goodness-of-fit hypothesis test. The
htest object has the elements:
\itemize{
\item \code{method}: Simple or Composite
\item \code{data.name}
\item \code{distribution}: The distribution object created to test
\item \code{parameter}: List of parameters if the test is simple
\item \code{nsim}: Number of bootstrap replicates
\item \code{composite_p}: TRUE/FALSE composite predicate
\item \code{statistic}: The value of the energy statistic (\eqn{Q=nE^*})
\item \code{p.value}
\item \code{sim_reps}: bootstrap replicates of energy statistic
\item \code{estimate}: Any parameter estimates, if the test is composite
}
}
\description{
This is an alternative interface that provides the same
parametric tests as \code{\link[=energyGOF.test]{energyGOF.test()}}, but allows the user to directly
pass a distribution object like \code{\link[=normal_dist]{normal_dist()}} (Distribution objects are
specific to the implementation of this R package). The advantage is that
you do not need to pass distribution parameters into a \code{...} argument as
in energyGOF.test(). energyGOF.test() uses this function under the hood,
but it's perfectly suitable for the user to use as well.
}
\examples{
## Simple normal test
energyGOFdist(rnorm(10), normal_dist(0, 1), nsim = 10)

## Simple Poisson test
egofd(rpois(10,1), poisson_dist(1), nsim = 0) # No p-value

## Composite Normal test
egofd(rnorm(10), normal_dist(), nsim = 10)


}
\author{
John T. Haman
}
