# Generated by 02-duckplyr_df-methods.R
#' @rdname compute.duckplyr_df
#' @export
compute.duckplyr_df <- function(
  x,
  ...,
  prudence = NULL,
  name = NULL,
  schema_name = NULL,
  temporary = TRUE
) {
  if (is.null(prudence)) {
    prudence <- get_prudence_duckplyr_df(x)
  }
  if (is.null(schema_name)) {
    schema_name <- ""
  }
  if (is.null(name)) {
    if (isTRUE(temporary)) {
      name <- unique_table_name()
    } else {
      cli::cli_abort("{.arg name} must be provided if {.arg temporary} is {.value FALSE}")
    }
  }

  # Our implementation
  duckplyr_error <- rel_try(NULL,
    {
      rel <- duckdb_rel_from_df(x)

      duckdb$rel_to_table(rel, schema_name, name, temporary)

      # API inconsistency: order of name and schema_name
      out_rel <- duckdb$rel_from_table(get_default_duckdb_connection(), name, schema_name)

      out <- duckplyr_reconstruct(out_rel, x)

      if (get_prudence_duckplyr_df(out) != prudence) {
        out <- as_duckdb_tibble(out, prudence = prudence)
      }

      return(out)
    }
  )

  # Unconditionally signal error
  # (If we can't compute, something's weird here.)
  if (is.character(duckplyr_error)) {
    cli::cli_abort(duckplyr_error)
  } else {
    cnd_signal(duckplyr_error)
  }
}

duckplyr_compute <- function(x, ...) {
  try_fetch(
    x <- as_duckplyr_df_impl(x),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- compute(x, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
