% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.kurtosis.R
\name{ds.kurtosis}
\alias{ds.kurtosis}
\title{Calculates the kurtosis of a numeric variable}
\usage{
ds.kurtosis(x = NULL, method = 1, type = "both", datasources = NULL)
}
\arguments{
\item{x}{a string character, the name of a numeric variable.}

\item{method}{an integer between 1 and 3 selecting one of the algorithms for computing kurtosis
detailed below. The default value is set to 1.}

\item{type}{a character which represents the type of analysis to carry out. 
If \code{type} is set to 'combine', 'combined', 'combines' or 'c', the global kurtosis is returned 
if \code{type} is set to 'split', 'splits' or 's', the kurtosis is returned separately for each study.
if \code{type} is set to 'both' or 'b', both sets of outputs are produced.
The default value is set to 'both'.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} objects obtained after login. 
If the \code{datasources} argument is not specified 
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
a matrix showing the kurtosis of the input numeric variable, the number of valid observations and
the validity message.
}
\description{
This function calculates the kurtosis of a numeric variable.
}
\details{
The function calculates the kurtosis of an input variable x with three different methods. 
The method is specified by the argument \code{method}. If x contains any missings, the function removes those before
the calculation of the kurtosis. If \code{method} is set to 1 the following formula is used
\eqn{ kurtosis= \frac{\sum_{i=1}^{N} (x_i - \bar(x))^4 /N}{(\sum_{i=1}^{N} ((x_i - \bar(x))^2) /N)^(2) } - 3},
where \eqn{ \bar{x} } is the mean of x and \eqn{N} is the number of observations. If \code{method} is set to 2
the following formula is used \eqn{ kurtosis= ((N+1)*(\frac{\sum_{i=1}^{N} (x_i - \bar(x))^4 /N}{(\sum_{i=1}^{N} ((x_i - \bar(x))^2) /N)^(2) } - 3) + 6)*((N-1)/((N-2)*(N-3)))}.
If \code{method} is set to 3 the following formula is used \eqn{ kurtosis= (\frac{\sum_{i=1}^{N} (x_i - \bar(x))^4 /N}{(\sum_{i=1}^{N} ((x_i - \bar(x))^2) /N)^(2) })*(1-1/N)^2 - 3}.
This function is similar to the function \code{kurtosis} in R package \code{e1071}.
}
\author{
Demetris Avraam, for DataSHIELD Development Team
}
