% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-maximize.R, R/verb-minimize.R
\name{maximize}
\alias{maximize}
\alias{maximise}
\alias{minimize}
\alias{minimise}
\title{Extremum of Several Distributions}
\usage{
maximize(
  ...,
  draws = 1,
  na_action_dst = c("null", "drop", "fail"),
  na_action_draws = c("null", "drop", "fail")
)

minimize(
  ...,
  draws = 1,
  na_action_dst = c("null", "drop", "fail"),
  na_action_draws = c("null", "drop", "fail")
)
}
\arguments{
\item{...}{Distribution objects, or list of distributions.}

\item{draws}{Number of draws from each distribution considered in the
maximum (possibly not integer, but never negative).
Either a single numeric applying to all distributions in \code{...},
or a vector matching the number of distributions in \code{...}.}

\item{na_action_dst, na_action_draws}{What should be done with Null
distributions in \code{...} and \code{NA} in \code{draws}?
Character vector of length 1:
one of "fail", "null" (default), or "drop". See details.}
}
\value{
A distribution corresponding to the maximum or minimum.
}
\description{
For a collection of distributions, obtain the distributions of the
maximum (\code{maximize()}) and minimum (\code{minimize()}) from independent draws of
each component distribution.

Aliases \code{maximise()} and \code{minimise()} are also provided.
}
\details{
To give an example of what distribution is returned, if X1 and X2 are
two random variables with distributions D1 and D2 respectively, then
\code{maximize(D1, D2, draws = c(2, 3))} returns the distribution of
\code{max(X1, X1, X2, X2, X2)}.

Distributions in \code{...} and the \code{draws} vector are recycled to have the
same length, but only if one of them has length 1
(via \code{vctrs::vec_recycle_common()}).

\code{na_action_dst} and \code{na_action_draws} specify the NA action for distributions
and \code{draws}. "NA" here means either \code{NA} in the \code{draws} vector, or
a Null distribution (\code{distionary::dst_null()}) in the distributions.
Options are, in order of precedence:
\itemize{
\item \code{"fail"}: Throw an error in the presence of NAs.
\item \code{"null"}: Return a Null distribution in the presence of NAs.
\item \code{"drop"}: Remove distribution-weight pairs having an NA value
}

Simplifications made in these functions include the following:
\itemize{
\item If any distributions are entirely to the left (right) of others,
then they are removed from consideration in \code{maximize()} (\code{minimize()}).
\item If all Finite distributions are input, the result is also a Finite
distribution.
\item If the same distribution is input multiple times, their corresponding
draws are summed.
}
}
\examples{
library(distionary)
# One is always more extreme than the other in this case.
d1 <- dst_unif(-1, 2)
d2 <- dst_unif(5, 6)
maximize(d1, d2) # d2
minimize(d1, d2) # d1

# Visualizing the maximum and minimum
d3 <- dst_norm(4, 1)
d4 <- dst_exp(0.3)

dmax <- maximize(d3, d4, draws = 1:2)
dmin <- minimize(d3, d4, draws = 1:2)

# Maximum
plot(d3, col = "blue", lty = 2, from = 0, to = 14)
plot(d4, col = "red", lty = 2, add = TRUE)
plot(dmax, add = TRUE, n = 1000)
legend(
 "topright",
 legend = c("Maximum", "N(4,1)", "Exp(0.3)"),
 col = c("black", "blue", "red"),
 lty = c(1, 2, 2)
)

# Minimum
plot(d3, col = "blue", lty = 2, from = 0, to = 10)
plot(d4, col = "red", lty = 2, add = TRUE)
plot(dmin, add = TRUE, n = 1000)
legend(
  "topright",
  legend = c("Minimum", "N(4,1)", "Exp(0.3)"),
  col = c("black", "blue", "red"),
  lty = c(1, 2, 2)
)

}
