% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dst_gev.R
\name{dst_gev}
\alias{dst_gev}
\title{Generalised Extreme Value Distribution}
\usage{
dst_gev(location, scale, shape)
}
\arguments{
\item{location}{Location parameter; single numeric.}

\item{scale}{Scale parameter; single positive numeric.}

\item{shape}{Shape parameter; single numeric.
This is also the extreme value index,
so that \code{shape > 0} is heavy tailed, and \code{shape < 0} is short-tailed.}
}
\value{
A GEV distribution.
}
\description{
Makes a Generalised Extreme Value (GEV) distribution, which is the
limiting distribution of the maximum.
}
\examples{
# Short-tailed example
short <- dst_gev(0, 1, -1)
range(short)
mean(short)

# Heavy-tailed example
heavy <- dst_gev(0, 1, 1)
range(heavy)
mean(heavy)

# Light-tailed example (a Gumbel distribution)
light <- dst_gev(0, 1, 0)
range(light)
mean(light)
}
