% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_helpers.R
\name{add_years}
\alias{add_years}
\title{Backend-dependent time interval (in years)}
\usage{
add_years(reference_date, years, conn)
}
\arguments{
\item{reference_date}{(\code{Date(1)} or \code{character(1)})\cr
The date to add years to (or name of column containing the reference date).}

\item{years}{(\code{numeric(1)} or \code{character(1)})\cr
The length of the time interval in whole years (or name of column containing the number of years).}

\item{conn}{(\code{DBIConnection} or \code{function})\cr A database connection or function that opens a database connection.}
}
\value{
SQL query for the time interval.
}
\description{
Provides the sql code for a time interval (in years).
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- SCDB::get_connection(drv = RSQLite::SQLite())

  dplyr::copy_to(conn, data.frame(birth = as.Date("2001-04-03"), "test_age")) |>
    dplyr::mutate(first_birthday = !!add_years("birth", 1, conn))

  DBI::dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
