% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_accuracy.R
\name{diag_accuracy}
\alias{diag_accuracy}
\title{Diagnostic Accuracy Metrics with Optional 2x2 Table}
\usage{
diag_accuracy(data, test_col, gold_col, descriptive = FALSE)
}
\arguments{
\item{data}{A data frame containing the test results and gold standard.}

\item{test_col}{Character. Name of the column in \code{data} with test results ("positive"/"negative").}

\item{gold_col}{Character. Name of the column in \code{data} with gold standard results ("positive"/"negative").}

\item{descriptive}{Logical. If TRUE, prints a descriptive 2x2 table with counts (TN, TP, FP, FN). Default is FALSE.}
}
\value{
A \code{flextable} object summarizing diagnostic metrics with 95\% CI.
If \code{descriptive = TRUE}, also prints a 2x2 table of counts.
}
\description{
Calculates diagnostic accuracy measures (Sensitivity, Specificity, PPV, NPV, Accuracy, LR+, LR-, DOR)
from a binary test and gold standard. Provides 95\% confidence intervals using Wilson method
for proportions and log method for ratios. Optionally, prints a descriptive 2x2 table.
}
\examples{
diagnostic_data <- data.frame(
  test = c("positive","negative","positive","
  negative","positive","negative","positive","negative"),
  goldstandard = c("positive","positive","negative",
  "negative","positive","negative","positive","negative")
)
diag_accuracy(diagnostic_data, test_col = "test",
gold_col = "goldstandard",
descriptive = FALSE)
}
