% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemical_by_property_range}
\alias{get_chemical_by_property_range}
\title{Get chemicals by property and its value range}
\usage{
get_chemical_by_property_range(
  start = NULL,
  end = NULL,
  property = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{start}{A numeric value, the beginning of the range}

\item{end}{A numeric value, the end of the range}

\item{property}{A string, the property in question}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be
given.}
}
\value{
A data.frame containing chemical information for chemicals matching
the search criteria.
}
\description{
Get chemicals by property and its value range
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull chemicals with a given property in a set range
density <- get_chemical_by_property_range(start = 1.311, end = 1.313,
                                          property = 'Density')
\dontshow{\}) # examplesIf}
}
