% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dens_ind.R
\name{calc_dens_ind_multiple}
\alias{calc_dens_ind_multiple}
\title{Calculate the density of K-dimensional multivariate normal (all dimensions are independent) under fitted acsGmm.}
\usage{
calc_dens_ind_multiple(x, Zmat)
}
\arguments{
\item{x}{K*1 vector of means.}

\item{Zmat}{J*K matrix of test statistics.}
}
\value{
A J*1 vector of densities for each row of Zmat.
}
\description{
Calculate the density of K-dimensional multivariate normal (all dimensions are independent) under fitted acsGmm.
}
\examples{
x <- c(0, 0)
Zmat <- cbind(rnorm(10^5), rnorm(10^5), rnorm(10^5), rnorm(10^5))
calc_dens_ind_multiple(x, Zmat)

}
