% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{assert}
\alias{assert}
\title{Assert truthfulness of conditions before evaluation}
\usage{
assert(..., error_message = NULL)
}
\arguments{
\item{...}{expressions >= 1. If named the names are used
as error messages, otherwise R's internal error-messages are thrown}

\item{error_message}{character. An error message, supports \link[cli:cli]{cli::cli}-formatting.}
}
\value{
\link{NULL} if all statements in ... are \link{TRUE}
}
\description{
This function is a wrapper of \code{\link[=stopifnot]{stopifnot()}}, \code{\link[=tryCatch]{tryCatch()}} and
\code{\link[cli:cli_abort]{cli::cli_abort()}} and asserts the truthfulness of the passed expression(s).
}
\examples{
\dontrun{
  # script start;

  # 1) unnamed assert
  # expressions
  foo <- function(
    a,
    b) {

    # assert without
    # named expressions
    cryptoQuotes:::assert(
      is.numeric(a),
      is.numeric(b)
    )

    a + b

  }

  # 1.1) returns
  # the regular R error
  # messages in cli-format
  foo(
    a = "1",
    b = "2"
  )

  # 2) named assert
  # expressions
  foo <- function(
    a,
    b) {

    cryptoQuotes:::assert(
      "{.arg a} is not {.cls numeric}" =  is.numeric(a),
      "{.arg a} is not {.cls numeric}" = is.numeric(b)
    )

    a + b

  }

  # 2.2) Returns
  # custom error-messages
  # in cli-format
  foo(
    a = "1",
    b = "2"
  )

  # 3) custom error
  # messages on
  foo <- function(
    a) {

    cryptoQuotes:::assert(
      is.numeric(a),
      error_message = sprintf(
        fmt = "{.val \%s} is not a numeric value.",
        a
      )
    )

    a

  }

  # 2.2) Returns
  # custom error-messages with
  # passed values in cli-format
  foo(
    a = "1"
  )

  # script end;
}
}
\seealso{
\code{\link[=stopifnot]{stopifnot()}}, \code{\link[cli:cli_abort]{cli::cli_abort()}}, \code{\link[=tryCatch]{tryCatch()}}
}
\keyword{internal}
