% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress_days_over.R
\name{stress_days_over}
\alias{stress_days_over}
\title{The number of days that maximum temp is over a baseline value}
\usage{
stress_days_over(
  data,
  var = NULL,
  datevar = NULL,
  ndays = 5,
  na.rm = FALSE,
  stress_temp = 30,
  startdate = NULL,
  enddate = NULL,
  monitor = FALSE,
  warn.consecutive = TRUE,
  ...
)
}
\arguments{
\item{data}{Tibble or dataframe of daily weather data}

\item{var}{Variable to be extracted (Default: maxt)}

\item{datevar}{Date variable specifying day (Default: date_met)}

\item{ndays}{Number of days after/before the start or end date,
respectively. Ignored of both the start and end dates are
specified (Default: 5)}

\item{na.rm}{Used for calculations (Default: FALSE)}

\item{stress_temp}{A numeric value set to the temperature
considered to be stressful if the maximum temperature exceeds
(Default: 30)}

\item{startdate}{Start date of data to be extracted}

\item{enddate}{Final date of data to be extracted}

\item{monitor}{For debugging. Prints data and dates. (Default:
FALSE)}

\item{warn.consecutive}{A logical indicating whether to check that
dates are consecutive, that none are missing and provide a warning if
not (Default:TRUE)}

\item{...}{options to be passed to \code{sum} calculation}
}
\value{
Numeric variable containing the number of days where the
maximum temperature was above the specified stress temperature
cutoff
}
\description{
Calculate the number of days when the maximum temperature exceeds
a base line \code{stress_temp} during specified dates for a tibble
or data frame of daily weather data.  Alternatively, a number of
days before or after a specific date may be specified. The default
value of \code{stress_temp} is 30 degrees C.
}
\details{
The number of days is returned but if there are any missing
values, then the sum is set to \code{NA} since the default
\code{na.rm} is \code{TRUE}. Note that if there are any missing
dates, then a warning is issued but the sum of non-missing values
is returned.

If any values are missing, while the number of days over
\code{stress_temp} total may prove useful, it will not include all
the data and so may lead to biased underestimates. Hence,
depending on the time of year, it may be unlikely that this is a
good estimate but the appropriateness of the estimate will depend
on the exact circumstances of the missing data and so this
decision is left to the user.
}
\examples{
##  Selected calculations
## library(tidyverse) # only purrr used here for crop2 example
library(dplyr)
library(purrr)
stress_days_over(boonah, enddate = crop$flower_date[4], ndays = 3,
                 monitor = TRUE)
stress_days_over(boonah, enddate = crop$harvest_date[4], ndays = 3,
                 monitor = TRUE)
stress_days_over(boonah, startdate = crop$flower_date[4],
                 enddate = crop$harvest_date[4], monitor = TRUE)

## Add selected stress days at 'boonah' to 'crop' tibble
## using 'map2_dbl' from the 'purrr' package
## Note: using equivalent 'furrr' functions can speed up calculations 
crop2 <- crop |>
  mutate(stressdays25_post_sow_7d =
          purrr::map_dbl(sowing_date, function(x)
            stress_days_over(boonah, startdate = x, ndays = 7,
                             stress_temp = 25)),
          stressdays_flower_harvest =
            purrr::map2_dbl(flower_date, harvest_date, function(x, y)
              stress_days_over(boonah, startdate = x, enddate = y)))
crop2

}
\seealso{
\code{\link{cumulative}}, \code{\link{daily_mean}},
\code{\link{growing_degree_days}}, and
\code{\link{weather_extract}}
}
