% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_shell.R
\name{extract_shell}
\alias{extract_shell}
\title{Turn a 'cmd_assign' Call Into a Shell Command}
\usage{
extract_shell(path_file, dir_shell = NULL)
}
\arguments{
\item{path_file}{Path to the R script containing
the call to \code{\link[=cmd_assign]{cmd_assign()}}. The path
starts at \code{dir_shell}.}

\item{dir_shell}{The directory that contains
the shell script. The default is
the current working directory.}
}
\value{
\code{extract_shell()} is typically called
for its side effect, which is to print a
shell command. However, \code{extract_shell()}
invisibly returns a text string with the command.
}
\description{
Extract a call to \code{\link[=cmd_assign]{cmd_assign()}} from an
R script, and turn it into a shell command.
}
\section{The components of a shell command}{
The shell command produced by \code{extract_shell()}
normally looks something like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Rscript src/model.R \\
  data/cleaned.rds \\
  out/model.rds \\
  --use_log=TRUE
}\if{html}{\out{</div>}}

In this command
\itemize{
\item \code{Rscript} is a call to \code{\link[utils:Rscript]{utils::Rscript()}};
\item \verb{\\} is a "line continuation character";
\item \code{data/cleaned.rds} and \code{out/model.rds} are unnamed
arguments that Rscript passes to \code{src/model.R}; and
\item \code{--use_log=TRUE} is a named argument that
Rscript passes to \code{src/model.R}
}
}

\section{Using \code{extract_shell()} to build a data analysis workflow}{
\itemize{
\item Step 1. Write an R script that carries out
a step in analysis (eg tidying data, fitting
a model, making a graph.) This script
will contain a call to \code{\link[=cmd_assign]{cmd_assign()}},
and  will be the first argument passed to
Rscript in the shell command.
When writing and testing the script,
use \code{\link[=cmd_assign]{cmd_assign()}} interactively.
\item Step 2. Once the R script is working correctly,
call \code{extract_shell()}, and add the command
to your shell script.
}
}

\section{Location of the shell script}{
The shell script normally sits at the
top level of the project, so that the
project folder looks something like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{workflow.sh
- data/
- src/
- out/
report.qmd
}\if{html}{\out{</div>}}
}

\section{Identifying file arguments}{
To construct the rule, \code{extract_shell()} needs to
be able to identify arguments that refer to a
file name. To do so, it uses the following heuristic:
\itemize{
\item if the call includes arguments whose names start with
a dot, then these arguments are assumed to
refer to file names;
\item otherwise, find arguments whose values
actually are file names
(as determined by \code{\link[=file.exists]{file.exists()}}) or that look
like they could be.
}
}

\examples{
library(fs)
library(withr)

with_tempdir({

  ## create 'src' directory
  dir_create("src")

  ## add an R script containing a call to 'cmd_assign'
  writeLines(c("cmd_assign(x = 1, .out = 'out/results.rds')",
               "results <- x + 1",
               "saveRDS(results, file = .out)"),
             con = "src/results.R")

  ## call 'extract_shell()'
  extract_shell(path_file = "src/results.R",
                dir_shell = ".")

})
}
\references{
\itemize{
\item Episodes 1--3 of \href{https://swcarpentry.github.io/shell-novice/index.html}{The Unix Shell}
Introduction to the command line
\item \href{https://swcarpentry.github.io/r-novice-inflammation/05-cmdline.html}{Command-Line Programs}
Introduction to Rscript
\item \href{https://CRAN.R-project.org/package=littler}{littler} Alternative to Rscript
}
}
\seealso{
\itemize{
\item \code{\link[=extract_make]{extract_make()}} Makefile equivalent of \code{extract_shell()}
\item \code{\link[=shell_script]{shell_script()}} Create a shell script
from calls to \code{\link[=cmd_assign]{cmd_assign()}}
\item \code{\link[=cmd_assign]{cmd_assign()}} Process command line arguments
\item \href{https://bayesiandemography.github.io/command/articles/quickstart.html}{Quick Start Guide}
How to use \code{cmd_assign()}
\item \href{https://bayesiandemography.github.io/command/articles/workflow.html}{Modular Workflows for Data Analysis}
Safe, flexible data analysis workflows
}
}
