% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_plot.R
\name{ssm_plot_contrast}
\alias{ssm_plot_contrast}
\title{Create a Difference Plot of SSM Contrast Results}
\usage{
ssm_plot_contrast(
  ssm_object,
  drop_xy = FALSE,
  sig_color = "#fc8d62",
  ns_color = "white",
  linesize = 1.25,
  fontsize = 12,
  ...
)
}
\arguments{
\item{ssm_object}{Required. The results output of \code{ssm_analyze()}.}

\item{drop_xy}{A logical determining whether the X-Value and Y-Value
parameters should be removed from the plot (default = FALSE).}

\item{sig_color}{Optional. A string corresponding to the color to use to
denote significant contrasts (default = "#fc8d62").}

\item{ns_color}{Optional. A string corresponding to the color to use to
denote non-significant contrasts (default = "white").}

\item{linesize}{Optional. A positive number corresponding to the size of the
point range elements in mm (default = 1.5).}

\item{fontsize}{Optional. A positive number corresponding to the size of the
axis labels, numbers, and facet headings in pt (default = 12).}

\item{...}{Additional arguments will be ignored.}
}
\value{
A ggplot variable containing difference point-ranges faceted by SSM
parameter. An interval that does not contain the value of zero has p<.05.
}
\description{
Take in the results of a Structural Summary Method analysis with pairwise
contrasts and plot the point and interval estimates for each parameter's
contrast (e.g., between groups or measures).
}
\examples{
\donttest{
data("jz2017")
res <- ssm_analyze(
  jz2017,
  scales = 2:9,
  measures = c("NARPD", "ASPD"),
  contrast = TRUE
)
ssm_plot_contrast(res)
}
}
