% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.R
\name{unique_}
\alias{unique_}
\title{An alternative \code{unique} function}
\usage{
unique_(x, sort = FALSE)
}
\arguments{
\item{x}{A vector (or data frame).}

\item{sort}{Should unique result be sorted? Default is \code{FALSE}.}
}
\value{
A unique vector (or data frame).
}
\description{
\code{unique_()} is a usually faster alternative to \code{unique()} with optional
sorting included. The internal API of this function is designed to be
simple and generic to allow for working with all kinds of objects that can
be reduced to a unique set.

Internally \code{unique_()} calculates unique group IDs for the given vector
in the range \verb{[1, n]} where \code{1} denotes the first group and \code{n} denotes
the nth group.
This function will work correctly as long as there
is a correctly implemented \code{collapse::GRP} method and a \code{[} method
for the object.
In the future cheapr will include a \code{group_id} S3 generic to replace the use
of \code{collapse::GRP} here, of which is arguably more difficult to write correct
methods for.
}
\examples{

library(cheapr)

x <- rep_(3:1, 3)
unique_(x)
unique_(x, sort = TRUE)

# Unique rows
iris |>
  sset(j = c("Petal.Width", "Species")) |>
  unique_()
}
