% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{timeStep}
\alias{timeStep}
\title{Compute Time Step of Tracks}
\usage{
timeStep(x, FUN = median, na.rm = FALSE)
}
\arguments{
\item{x}{the input tracks.}

\item{FUN}{the summary statistic to be applied.}

\item{na.rm}{logical, indicates whether to remove missing values before applying FUN.}
}
\value{
Summary statistic of the time intervals between two consecutive positions in a track
dataset.
}
\description{
Applies a summary statistics on the time intervals between pairs of consecutive
positions in a track dataset.
}
\details{
Most track quantification depends on the assumption that track positions are
recorded at constant time intervals. If this is not the case, then most of the statistics
in this package (except for some very simple ones like \code{\link{duration}}) will not work.
In reality, at least small fluctuations of the time steps can be expected. This
function provides a means for quality control with respect to the tracking time.
}
\examples{
## Show tracking time fluctuations for the T cell data
d <- timeStep( TCells )
plot( sapply( subtracks( TCells, 1 ) , duration ) - d, ylim=c(-d,d) )

}
