% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{analyzeStepPairs}
\alias{analyzeStepPairs}
\title{Find Distances and Angles for all Pairs of Steps}
\usage{
analyzeStepPairs(
  X,
  filter.steps = NULL,
  searchRadius = Inf,
  quietly = FALSE,
  ...
)
}
\arguments{
\item{X}{a tracks object}

\item{filter.steps}{optional: a function used to filter steps on. See examples.}

\item{searchRadius}{if specified, only return analysis for pairs of steps that
start within distance searchRadius from each other}

\item{quietly}{(default FALSE) if TRUE, suppress warnings}

\item{...}{further arguments passed on to \code{angleSteps}}
}
\value{
A dataframe with five columns: two for the indices of cellpairs that
share a step, one for the timepoint at which they do so, one for the distance
between them, and one for their angle.
}
\description{
Find cell indices and timepoints where these cells both have a step, then return
angles and distances for each pair of steps.
}
\details{
Analyzing step angles at different distances can be useful to detect
directional bias or local crowding effects; see (Beltman et al, 2009).

Internally, the function uses \code{\link{stepPairs}}, \code{\link{angleSteps}},
and \code{\link{distanceSteps}}.
}
\examples{
## Plot distance versus angle for all step pairs, filtering for those that
## displace at least 2 microns. Sample dataset in this example for speed.
pairs <- analyzeStepPairs( sample( TCells, 100), filter.steps = function(t) displacement(t) > 2 )
scatter.smooth( pairs$dist, pairs$angle )
}
\references{
Joost B. Beltman, Athanasius F.M. Maree and Rob. J. de Boer (2009),
Analysing immune cell migration. \emph{Nature Reviews Immunology} \bold{9},
789--798. doi:10.1038/nri2638
}
\seealso{
\code{\link{analyzeCellPairs}} to do something similar for entire tracks
rather than single steps.
}
