% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_onegrid}
\alias{make_onegrid}
\title{Generate a Single Grid Cluster in High Dimensions}
\usage{
make_onegrid(n = 500)
}
\arguments{
\item{n}{Integer, the number of points in the grid cluster. Must be positive.
Default is \code{500}.}
}
\value{
A tibble containing the generated dataset with columns:
  \itemize{
    \item \code{x1, x2, x3, x4} — coordinates of the data points.
    \item \code{cluster} — cluster assignment (always 1 for the grid).
  }
}
\description{
This function generates a dataset consisting of one grid-like cluster
(a structured cube grid) in 2D, with optional Gaussian noise dimensions
added to extend the dataset into higher dimensions.
}
\examples{
# Default: 500 points, 4D space (grid in 2D + 2 noise dimensions)
onegrid <- make_onegrid()


}
