% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_shape_para}
\alias{make_shape_para}
\title{Generate Parallel Multi-Shape Clusters}
\usage{
make_shape_para(n = c(500, 300), k = 2, p = 4, shift = 0.4, shape = "crescent")
}
\arguments{
\item{n}{A numeric vector of length \eqn{k}, specifying the number of
observations in each cluster. All values must be positive.}

\item{k}{Integer. Number of clusters to generate. Must be greater than 1.}

\item{p}{Integer. Number of dimensions. Must be at least 3.}

\item{shift}{Numeric. The distance between cluster centers along the
alternating dimensions (default is `0.4`).}

\item{shape}{Character string. Shape of the clusters to generate (e.g.,
`"crescent"`, `"gridcube"`, etc.). Must be a single value.}
}
\value{
A tibble containing \eqn{\sum n} rows and \eqn{p} columns, with
  the generated features (`x1, x2, ..., xp`) and a `cluster` label.
}
\description{
This function generates synthetic high-dimensional data consisting of
\eqn{k} clusters of a specified shape (e.g., crescents), arranged in
parallel along alternating dimensions. The first cluster is shifted
along the first dimension, the second along the third dimension,
the third along the first dimension again, and so on.
}
\examples{
# Generate 2 crescent-shaped clusters in 4D
twocrescent <- make_shape_para(n = c(500, 300), k = 2, p = 4, shape = "crescent")


}
