% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shash.R
\name{predict.cnormShash}
\alias{predict.cnormShash}
\title{Predict Norm Scores from Raw Scores}
\usage{
\method{predict}{cnormShash}(object, ...)
}
\arguments{
\item{object}{A fitted model object of class 'cnormShash'.}

\item{...}{Additional arguments passed to the prediction method:
\itemize{
   \item age A numeric vector of ages, same length as score.
   \item score A numeric vector of raw scores.
   \item range The range of the norm scores in standard deviations. Default is 3.
     Thus, scores in the range of +/- 3 standard deviations are considered.
 }}
}
\value{
A numeric vector of norm scores.
}
\description{
This function calculates norm scores based on raw scores, age, and a fitted cnormShash model.
}
\details{
The function predicts the SinH-ArcSinH (shash) distribution parameters (mu, sigma, epsilon, delta) for each age
using the provided model. It then calculates the cumulative probability for each
raw score given these parameters using the continuous shash distribution. Finally,
it converts these probabilities to the norm scale specified in the model.
}
\examples{
\dontrun{
# Assuming you have a fitted model named 'shash_model':
model <- cnorm.shash(children$age, children$score)
raw_scores <- c(25.5, 30.2, 18.7, 45.3)
ages <- c(7, 8, 9, 10)
norm_scores <- predict(model, ages, raw_scores)
}

}
\seealso{
Other predict: 
\code{\link{derivationTable}()},
\code{\link{getNormCurve}()},
\code{\link{normTable}()},
\code{\link{predict.cnormBetaBinomial}()},
\code{\link{predict.cnormBetaBinomial2}()},
\code{\link{predictNorm}()},
\code{\link{predictRaw}()},
\code{\link{rawTable}()}
}
\concept{predict}
