% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_diff_by_group.R
\name{coef_diff_by_group}
\alias{coef_diff_by_group}
\title{Tabulates breath test parameter differences of groups}
\usage{
coef_diff_by_group(fit, mcp_group = "Tukey", reference_group = NULL, ...)
}
\arguments{
\item{fit}{Object of class \code{breathtestfit}, for example from
\code{\link{nlme_fit}}, \code{\link{nls_fit}}}

\item{mcp_group}{"Tukey" (default) for all pairwise comparisons, "Dunnett" for
comparisons relative to the reference group.}

\item{reference_group}{Used as the first group and as reference group for
\code{mcp_group == "Dunnett"}}

\item{...}{Not used}
}
\value{
A \code{tibble} of class \code{coef_diff_by_group} with columns
\describe{
  \item{parameter}{Parameter of fit, e.g. \code{beta, k, m, t50}}
  \item{method}{Method used to compute parameter. \code{exp_beta} refers to primary
  fit parameters \code{beta, k, m}. \code{maes_ghoos} uses the method from
  Maes B D, Ghoos Y F,
  Rutgeerts P J, Hiele M I, Geypens B and Vantrappen G 1994 Dig. Dis. Sci. 39 S104-6.
  \code{bluck_coward} is the self-correcting method from  Bluck L J C and
  Coward W A 2006}
  \item{groups}{Which pairwise difference, e.g \code{solid - liquid}}
  \item{estimate}{Estimate of the difference}
  \item{conf.low, conf.high}{Lower and upper 95% confidence interval of difference.
  A comparison is significantly different from zero when both estimates have the same
  sign.}
  \item{p.value}{p-value of the difference against 0, corrected for multiple testing}
}
}
\description{
Given a fit to 13C breath test curves, computes between-group confidence
intervals and p-values, for examples of the half emptying time \code{t50},
with correction for multiple testing.
}
\examples{
library(dplyr)
data("usz_13c")
data = usz_13c \%>\%
  dplyr::filter( patient_id \%in\%
    c("norm_001", "norm_002", "norm_003", "norm_004", "pat_001", "pat_002","pat_003")) \%>\%
  cleanup_data()
fit = nls_fit(data)
coef_diff_by_group(fit)
\donttest{
fit = nlme_fit(data)
coef_diff_by_group(fit)
}
# TODO: Add example for Stan fit typecast to class \code{breathtestfit} to compute
# confidence intervals instead of credible intervals
}
