% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass.R
\name{brand_sass_color}
\alias{brand_sass_color}
\title{Generate Sass variables for brand colors}
\usage{
brand_sass_color(brand)
}
\arguments{
\item{brand}{A list or string of YAML representing the brand, or a path to a
brand.yml file.}
}
\value{
A list with one component:
\itemize{
\item \code{defaults}: Sass variable definitions with \code{!default} flag
}
}
\description{
Creates Sass variables for brand colors with the \code{brand_color_} prefix.
Excludes the color palette which is handled by \code{brand_sass_color_palette()}.
}
\examples{
brand <- list(
  color = list(
    primary = "#007bff",
    danger = "#dc3545"
  )
)

brand_sass_color(brand)

}
\seealso{
Other brand.yml Sass helpers: 
\code{\link{brand_sass_color_palette}()},
\code{\link{brand_sass_defaults_bootstrap}()},
\code{\link{brand_sass_fonts}()},
\code{\link{brand_sass_typography}()}
}
\concept{brand.yml Sass helpers}
