% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{brand_has}
\alias{brand_has}
\title{Check if a brand has a specific nested element}
\usage{
brand_has(brand, ...)
}
\arguments{
\item{brand}{A brand object created by \code{\link[=read_brand_yml]{read_brand_yml()}} or
\code{\link[=as_brand_yml]{as_brand_yml()}}.}

\item{...}{One or more character strings or symbols representing the path to
the nested element.}
}
\value{
\code{TRUE} if the nested element exists in the brand object,
\code{FALSE} otherwise.
}
\description{
Checks if a given \code{brand} object has a specific nested element accessible via
the additional arguments provided as key paths.
}
\examples{
brand <- as_brand_yml(list(
  meta = list(name = "Example Brand"),
  color = list(primary = "#FF5733")
))

# Check if brand has a primary color
brand_has(brand, "color", "primary") # TRUE

# Check if brand has a secondary color
brand_has(brand, "color", "secondary") # FALSE

}
\seealso{
Other brand.yml helpers: 
\code{\link{brand_color_pluck}()},
\code{\link{brand_pluck}()},
\code{\link{with_brand_yml_path}()}
}
\concept{brand.yml helpers}
