% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_history_parameter.R
\name{extract_history_parameter}
\alias{extract_history_parameter}
\title{Extracts a history parameter as a matrix}
\usage{
extract_history_parameter(
  object,
  param_name,
  samplesN = NULL,
  link_function = NULL
)
}
\arguments{
\item{object}{A \link[=cumhist-class]{cumhist} object}

\item{param_name}{String, a name of the parameter}

\item{samplesN}{Number of samples, if NULL is computed from rstan (but it is cheaper to do this once).}

\item{link_function}{A link function to use (exp or inv.logit) or \code{NULL} for identity.}
}
\value{
Matrix with \code{samplesN} rows and randomN
(found in \code{object$data$randomN}) columns
}
\description{
Extracts a history parameter as a matrix with
\code{samplesN} rows and randomN (found in \code{object$data$randomN})
columns.
}
\examples{
\donttest{
br_fit <- fit_cumhist(br_singleblock, state="State", duration="Duration")
extract_history_parameter(br_fit, "tau", link_function = exp)
}
}
