% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_estimation.R
\name{calculate_yield}
\alias{calculate_yield}
\title{Calculate yield from dose}
\usage{
calculate_yield(
  dose,
  type = c("estimate", "lower", "upper"),
  general_fit_coeffs,
  general_fit_var_cov_mat = NULL,
  protracted_g_value = 1,
  conf_int = 0.95
)
}
\arguments{
\item{dose}{Numeric value of dose.}

\item{type}{Type of yield calculation. Can be "estimate", "lower", or "upper".}

\item{general_fit_coeffs}{Generalised fit coefficients matrix.}

\item{general_fit_var_cov_mat}{Generalised variance-covariance matrix.}

\item{protracted_g_value}{Protracted \eqn{G(x)} value.}

\item{conf_int}{Curve confidence interval, 95\% by default.}
}
\value{
Numeric value of yield.
}
\description{
Calculate yield from dose
}
