% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boe.R
\name{boe_data}
\alias{boe_data}
\title{Fetch Bank of England (BoE) data}
\source{
\url{https://www.bankofengland.co.uk/boeapps/database}
}
\usage{
boe_data(key, start_date, end_date = Sys.Date())
}
\arguments{
\item{key}{(\code{character()})\cr
The series keys to query.}

\item{start_date}{(\code{character(1)} | \code{Date(1)})\cr
Start date of the data.}

\item{end_date}{(\code{character(1)} | \code{Date(1)})\cr
End date of the data. Default is today's date.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve time series data from the BoE database.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
boe_data(c("IUMABEDR", "IUALBEDR"), "2015-01-01")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bde_data}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boc_data}()},
\code{\link{ecb_data}()},
\code{\link{onb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
