% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_class_functions.r
\name{attrs_order}
\alias{attrs_order}
\alias{attrs_order<-}
\title{Relational data attribute order}
\usage{
attrs_order(x, ...)

attrs_order(x, ...) <- value
}
\arguments{
\item{x}{an R object, such as a \code{\link{functional_dependency}},
\code{\link{relation_schema}}, \code{\link{relation}},
\code{\link{database_schema}}, or \code{\link{database}} object.}

\item{...}{further arguments passed on to methods.}

\item{value}{A character vector of the same length as \code{attrs_order(x, ...)}.}
}
\value{
A character vector, giving attributes in the order in which they're
prioritised for sorting within \code{x}.
}
\description{
Generic function, fetching attribute order for relational objects.
}
\details{
All classes in \code{autodb} contain an \code{attrs_order} attribute. It
gives an easy way to find a list of all attributes/variables involved in an
object, but its main purpose is to also assign those attributes a consistent
order when printing or plotting the object.
}
